package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainStreamTranscodeData invokes the live.DescribeLiveDomainStreamTranscodeData API synchronously
func (client *Client) DescribeLiveDomainStreamTranscodeData(request *DescribeLiveDomainStreamTranscodeDataRequest) (response *DescribeLiveDomainStreamTranscodeDataResponse, err error) {
	response = CreateDescribeLiveDomainStreamTranscodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainStreamTranscodeDataWithChan invokes the live.DescribeLiveDomainStreamTranscodeData API asynchronously
func (client *Client) DescribeLiveDomainStreamTranscodeDataWithChan(request *DescribeLiveDomainStreamTranscodeDataRequest) (<-chan *DescribeLiveDomainStreamTranscodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainStreamTranscodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainStreamTranscodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainStreamTranscodeDataWithCallback invokes the live.DescribeLiveDomainStreamTranscodeData API asynchronously
func (client *Client) DescribeLiveDomainStreamTranscodeDataWithCallback(request *DescribeLiveDomainStreamTranscodeDataRequest, callback func(response *DescribeLiveDomainStreamTranscodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainStreamTranscodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainStreamTranscodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainStreamTranscodeDataRequest is the request struct for api DescribeLiveDomainStreamTranscodeData
type DescribeLiveDomainStreamTranscodeDataRequest struct {
	*requests.RpcRequest
	Precision  string           `position:"Query" name:"Precision"`
	StartTime  string           `position:"Query" name:"StartTime"`
	Split      string           `position:"Query" name:"Split"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeLiveDomainStreamTranscodeDataResponse is the response struct for api DescribeLiveDomainStreamTranscodeData
type DescribeLiveDomainStreamTranscodeDataResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TranscodeDataList TranscodeDataList `json:"TranscodeDataList" xml:"TranscodeDataList"`
}

// CreateDescribeLiveDomainStreamTranscodeDataRequest creates a request to invoke DescribeLiveDomainStreamTranscodeData API
func CreateDescribeLiveDomainStreamTranscodeDataRequest() (request *DescribeLiveDomainStreamTranscodeDataRequest) {
	request = &DescribeLiveDomainStreamTranscodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainStreamTranscodeData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainStreamTranscodeDataResponse creates a response to parse from DescribeLiveDomainStreamTranscodeData response
func CreateDescribeLiveDomainStreamTranscodeDataResponse() (response *DescribeLiveDomainStreamTranscodeDataResponse) {
	response = &DescribeLiveDomainStreamTranscodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
