package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamDetailFrameRateAndBitRateData invokes the live.DescribeLiveStreamDetailFrameRateAndBitRateData API synchronously
func (client *Client) DescribeLiveStreamDetailFrameRateAndBitRateData(request *DescribeLiveStreamDetailFrameRateAndBitRateDataRequest) (response *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse, err error) {
	response = CreateDescribeLiveStreamDetailFrameRateAndBitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamDetailFrameRateAndBitRateDataWithChan invokes the live.DescribeLiveStreamDetailFrameRateAndBitRateData API asynchronously
func (client *Client) DescribeLiveStreamDetailFrameRateAndBitRateDataWithChan(request *DescribeLiveStreamDetailFrameRateAndBitRateDataRequest) (<-chan *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamDetailFrameRateAndBitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamDetailFrameRateAndBitRateDataWithCallback invokes the live.DescribeLiveStreamDetailFrameRateAndBitRateData API asynchronously
func (client *Client) DescribeLiveStreamDetailFrameRateAndBitRateDataWithCallback(request *DescribeLiveStreamDetailFrameRateAndBitRateDataRequest, callback func(response *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamDetailFrameRateAndBitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamDetailFrameRateAndBitRateDataRequest is the request struct for api DescribeLiveStreamDetailFrameRateAndBitRateData
type DescribeLiveStreamDetailFrameRateAndBitRateDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamDetailFrameRateAndBitRateDataResponse is the response struct for api DescribeLiveStreamDetailFrameRateAndBitRateData
type DescribeLiveStreamDetailFrameRateAndBitRateDataResponse struct {
	*responses.BaseResponse
	RequestId                string  `json:"RequestId" xml:"RequestId"`
	FrameRateAndBitRateInfos []Frabr `json:"FrameRateAndBitRateInfos" xml:"FrameRateAndBitRateInfos"`
}

// CreateDescribeLiveStreamDetailFrameRateAndBitRateDataRequest creates a request to invoke DescribeLiveStreamDetailFrameRateAndBitRateData API
func CreateDescribeLiveStreamDetailFrameRateAndBitRateDataRequest() (request *DescribeLiveStreamDetailFrameRateAndBitRateDataRequest) {
	request = &DescribeLiveStreamDetailFrameRateAndBitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamDetailFrameRateAndBitRateData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamDetailFrameRateAndBitRateDataResponse creates a response to parse from DescribeLiveStreamDetailFrameRateAndBitRateData response
func CreateDescribeLiveStreamDetailFrameRateAndBitRateDataResponse() (response *DescribeLiveStreamDetailFrameRateAndBitRateDataResponse) {
	response = &DescribeLiveStreamDetailFrameRateAndBitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
