package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamMerge invokes the live.DescribeLiveStreamMerge API synchronously
func (client *Client) DescribeLiveStreamMerge(request *DescribeLiveStreamMergeRequest) (response *DescribeLiveStreamMergeResponse, err error) {
	response = CreateDescribeLiveStreamMergeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamMergeWithChan invokes the live.DescribeLiveStreamMerge API asynchronously
func (client *Client) DescribeLiveStreamMergeWithChan(request *DescribeLiveStreamMergeRequest) (<-chan *DescribeLiveStreamMergeResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamMergeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamMerge(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamMergeWithCallback invokes the live.DescribeLiveStreamMerge API asynchronously
func (client *Client) DescribeLiveStreamMergeWithCallback(request *DescribeLiveStreamMergeRequest, callback func(response *DescribeLiveStreamMergeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamMergeResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamMerge(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamMergeRequest is the request struct for api DescribeLiveStreamMerge
type DescribeLiveStreamMergeRequest struct {
	*requests.RpcRequest
	Protocol   string           `position:"Query" name:"Protocol"`
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamMergeResponse is the response struct for api DescribeLiveStreamMerge
type DescribeLiveStreamMergeResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	LiveStreamMergeList LiveStreamMergeList `json:"LiveStreamMergeList" xml:"LiveStreamMergeList"`
}

// CreateDescribeLiveStreamMergeRequest creates a request to invoke DescribeLiveStreamMerge API
func CreateDescribeLiveStreamMergeRequest() (request *DescribeLiveStreamMergeRequest) {
	request = &DescribeLiveStreamMergeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamMerge", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamMergeResponse creates a response to parse from DescribeLiveStreamMerge response
func CreateDescribeLiveStreamMergeResponse() (response *DescribeLiveStreamMergeResponse) {
	response = &DescribeLiveStreamMergeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
