package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DynamicUpdateWaterMarkStreamRule invokes the live.DynamicUpdateWaterMarkStreamRule API synchronously
func (client *Client) DynamicUpdateWaterMarkStreamRule(request *DynamicUpdateWaterMarkStreamRuleRequest) (response *DynamicUpdateWaterMarkStreamRuleResponse, err error) {
	response = CreateDynamicUpdateWaterMarkStreamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DynamicUpdateWaterMarkStreamRuleWithChan invokes the live.DynamicUpdateWaterMarkStreamRule API asynchronously
func (client *Client) DynamicUpdateWaterMarkStreamRuleWithChan(request *DynamicUpdateWaterMarkStreamRuleRequest) (<-chan *DynamicUpdateWaterMarkStreamRuleResponse, <-chan error) {
	responseChan := make(chan *DynamicUpdateWaterMarkStreamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DynamicUpdateWaterMarkStreamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DynamicUpdateWaterMarkStreamRuleWithCallback invokes the live.DynamicUpdateWaterMarkStreamRule API asynchronously
func (client *Client) DynamicUpdateWaterMarkStreamRuleWithCallback(request *DynamicUpdateWaterMarkStreamRuleRequest, callback func(response *DynamicUpdateWaterMarkStreamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DynamicUpdateWaterMarkStreamRuleResponse
		var err error
		defer close(result)
		response, err = client.DynamicUpdateWaterMarkStreamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DynamicUpdateWaterMarkStreamRuleRequest is the request struct for api DynamicUpdateWaterMarkStreamRule
type DynamicUpdateWaterMarkStreamRuleRequest struct {
	*requests.RpcRequest
	Stream     string           `position:"Query" name:"Stream"`
	App        string           `position:"Query" name:"App"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId string           `position:"Query" name:"TemplateId"`
	Domain     string           `position:"Query" name:"Domain"`
}

// DynamicUpdateWaterMarkStreamRuleResponse is the response struct for api DynamicUpdateWaterMarkStreamRule
type DynamicUpdateWaterMarkStreamRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDynamicUpdateWaterMarkStreamRuleRequest creates a request to invoke DynamicUpdateWaterMarkStreamRule API
func CreateDynamicUpdateWaterMarkStreamRuleRequest() (request *DynamicUpdateWaterMarkStreamRuleRequest) {
	request = &DynamicUpdateWaterMarkStreamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DynamicUpdateWaterMarkStreamRule", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDynamicUpdateWaterMarkStreamRuleResponse creates a response to parse from DynamicUpdateWaterMarkStreamRule response
func CreateDynamicUpdateWaterMarkStreamRuleResponse() (response *DynamicUpdateWaterMarkStreamRuleResponse) {
	response = &DynamicUpdateWaterMarkStreamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
