package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EditShowAndReplace invokes the live.EditShowAndReplace API synchronously
func (client *Client) EditShowAndReplace(request *EditShowAndReplaceRequest) (response *EditShowAndReplaceResponse, err error) {
	response = CreateEditShowAndReplaceResponse()
	err = client.DoAction(request, response)
	return
}

// EditShowAndReplaceWithChan invokes the live.EditShowAndReplace API asynchronously
func (client *Client) EditShowAndReplaceWithChan(request *EditShowAndReplaceRequest) (<-chan *EditShowAndReplaceResponse, <-chan error) {
	responseChan := make(chan *EditShowAndReplaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EditShowAndReplace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EditShowAndReplaceWithCallback invokes the live.EditShowAndReplace API asynchronously
func (client *Client) EditShowAndReplaceWithCallback(request *EditShowAndReplaceRequest, callback func(response *EditShowAndReplaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EditShowAndReplaceResponse
		var err error
		defer close(result)
		response, err = client.EditShowAndReplace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EditShowAndReplaceRequest is the request struct for api EditShowAndReplace
type EditShowAndReplaceRequest struct {
	*requests.RpcRequest
	StartTime   requests.Float   `position:"Query" name:"StartTime"`
	UserData    string           `position:"Query" name:"UserData"`
	StorageInfo string           `position:"Query" name:"StorageInfo"`
	CasterId    string           `position:"Query" name:"CasterId"`
	EndTime     requests.Float   `position:"Query" name:"EndTime"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	ShowId      string           `position:"Query" name:"ShowId"`
}

// EditShowAndReplaceResponse is the response struct for api EditShowAndReplace
type EditShowAndReplaceResponse struct {
	*responses.BaseResponse
	JobInfo   string `json:"JobInfo" xml:"JobInfo"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEditShowAndReplaceRequest creates a request to invoke EditShowAndReplace API
func CreateEditShowAndReplaceRequest() (request *EditShowAndReplaceRequest) {
	request = &EditShowAndReplaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "EditShowAndReplace", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEditShowAndReplaceResponse creates a response to parse from EditShowAndReplace response
func CreateEditShowAndReplaceResponse() (response *EditShowAndReplaceResponse) {
	response = &EditShowAndReplaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
