package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPlaylist invokes the live.ListPlaylist API synchronously
func (client *Client) ListPlaylist(request *ListPlaylistRequest) (response *ListPlaylistResponse, err error) {
	response = CreateListPlaylistResponse()
	err = client.DoAction(request, response)
	return
}

// ListPlaylistWithChan invokes the live.ListPlaylist API asynchronously
func (client *Client) ListPlaylistWithChan(request *ListPlaylistRequest) (<-chan *ListPlaylistResponse, <-chan error) {
	responseChan := make(chan *ListPlaylistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPlaylist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPlaylistWithCallback invokes the live.ListPlaylist API asynchronously
func (client *Client) ListPlaylistWithCallback(request *ListPlaylistRequest, callback func(response *ListPlaylistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPlaylistResponse
		var err error
		defer close(result)
		response, err = client.ListPlaylist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPlaylistRequest is the request struct for api ListPlaylist
type ListPlaylistRequest struct {
	*requests.RpcRequest
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ProgramId string           `position:"Query" name:"ProgramId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Page      requests.Integer `position:"Query" name:"Page"`
}

// ListPlaylistResponse is the response struct for api ListPlaylist
type ListPlaylistResponse struct {
	*responses.BaseResponse
	RequestId   string        `json:"RequestId" xml:"RequestId"`
	Total       int           `json:"Total" xml:"Total"`
	ProgramList []ProgramInfo `json:"ProgramList" xml:"ProgramList"`
}

// CreateListPlaylistRequest creates a request to invoke ListPlaylist API
func CreateListPlaylistRequest() (request *ListPlaylistRequest) {
	request = &ListPlaylistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListPlaylist", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPlaylistResponse creates a response to parse from ListPlaylist response
func CreateListPlaylistResponse() (response *ListPlaylistResponse) {
	response = &ListPlaylistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
