package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MiguLivePullToPushStatus invokes the live.MiguLivePullToPushStatus API synchronously
func (client *Client) MiguLivePullToPushStatus(request *MiguLivePullToPushStatusRequest) (response *MiguLivePullToPushStatusResponse, err error) {
	response = CreateMiguLivePullToPushStatusResponse()
	err = client.DoAction(request, response)
	return
}

// MiguLivePullToPushStatusWithChan invokes the live.MiguLivePullToPushStatus API asynchronously
func (client *Client) MiguLivePullToPushStatusWithChan(request *MiguLivePullToPushStatusRequest) (<-chan *MiguLivePullToPushStatusResponse, <-chan error) {
	responseChan := make(chan *MiguLivePullToPushStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MiguLivePullToPushStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MiguLivePullToPushStatusWithCallback invokes the live.MiguLivePullToPushStatus API asynchronously
func (client *Client) MiguLivePullToPushStatusWithCallback(request *MiguLivePullToPushStatusRequest, callback func(response *MiguLivePullToPushStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MiguLivePullToPushStatusResponse
		var err error
		defer close(result)
		response, err = client.MiguLivePullToPushStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MiguLivePullToPushStatusRequest is the request struct for api MiguLivePullToPushStatus
type MiguLivePullToPushStatusRequest struct {
	*requests.RpcRequest
	MiguData   string           `position:"Query" name:"MiguData"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// MiguLivePullToPushStatusResponse is the response struct for api MiguLivePullToPushStatus
type MiguLivePullToPushStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"code" xml:"code"`
	Message   string `json:"message" xml:"message"`
	RequestId string `json:"requestId" xml:"requestId"`
	Timestamp string `json:"timestamp" xml:"timestamp"`
	Data      Data   `json:"data" xml:"data"`
}

// CreateMiguLivePullToPushStatusRequest creates a request to invoke MiguLivePullToPushStatus API
func CreateMiguLivePullToPushStatusRequest() (request *MiguLivePullToPushStatusRequest) {
	request = &MiguLivePullToPushStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "MiguLivePullToPushStatus", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMiguLivePullToPushStatusResponse creates a response to parse from MiguLivePullToPushStatus response
func CreateMiguLivePullToPushStatusResponse() (response *MiguLivePullToPushStatusResponse) {
	response = &MiguLivePullToPushStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
