package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachDataWithSignature invokes the ltl.AttachDataWithSignature API synchronously
func (client *Client) AttachDataWithSignature(request *AttachDataWithSignatureRequest) (response *AttachDataWithSignatureResponse, err error) {
	response = CreateAttachDataWithSignatureResponse()
	err = client.DoAction(request, response)
	return
}

// AttachDataWithSignatureWithChan invokes the ltl.AttachDataWithSignature API asynchronously
func (client *Client) AttachDataWithSignatureWithChan(request *AttachDataWithSignatureRequest) (<-chan *AttachDataWithSignatureResponse, <-chan error) {
	responseChan := make(chan *AttachDataWithSignatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachDataWithSignature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachDataWithSignatureWithCallback invokes the ltl.AttachDataWithSignature API asynchronously
func (client *Client) AttachDataWithSignatureWithCallback(request *AttachDataWithSignatureRequest, callback func(response *AttachDataWithSignatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachDataWithSignatureResponse
		var err error
		defer close(result)
		response, err = client.AttachDataWithSignature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachDataWithSignatureRequest is the request struct for api AttachDataWithSignature
type AttachDataWithSignatureRequest struct {
	*requests.RpcRequest
	IotSignature         string `position:"Query" name:"IotSignature"`
	IotAuthType          string `position:"Query" name:"IotAuthType"`
	IotIdSource          string `position:"Query" name:"IotIdSource"`
	BusinessId           string `position:"Query" name:"BusinessId"`
	ApiVersion           string `position:"Query" name:"ApiVersion"`
	ProductKey           string `position:"Query" name:"ProductKey"`
	IotId                string `position:"Query" name:"IotId"`
	IotDataDigest        string `position:"Query" name:"IotDataDigest"`
	IotIdServiceProvider string `position:"Query" name:"IotIdServiceProvider"`
	Value                string `position:"Query" name:"Value"`
	Key                  string `position:"Query" name:"Key"`
}

// AttachDataWithSignatureResponse is the response struct for api AttachDataWithSignature
type AttachDataWithSignatureResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAttachDataWithSignatureRequest creates a request to invoke AttachDataWithSignature API
func CreateAttachDataWithSignatureRequest() (request *AttachDataWithSignatureRequest) {
	request = &AttachDataWithSignatureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "AttachDataWithSignature", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachDataWithSignatureResponse creates a response to parse from AttachDataWithSignature response
func CreateAttachDataWithSignatureResponse() (response *AttachDataWithSignatureResponse) {
	response = &AttachDataWithSignatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
