package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeniedMemberAccess invokes the lto.DeniedMemberAccess API synchronously
func (client *Client) DeniedMemberAccess(request *DeniedMemberAccessRequest) (response *DeniedMemberAccessResponse, err error) {
	response = CreateDeniedMemberAccessResponse()
	err = client.DoAction(request, response)
	return
}

// DeniedMemberAccessWithChan invokes the lto.DeniedMemberAccess API asynchronously
func (client *Client) DeniedMemberAccessWithChan(request *DeniedMemberAccessRequest) (<-chan *DeniedMemberAccessResponse, <-chan error) {
	responseChan := make(chan *DeniedMemberAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeniedMemberAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeniedMemberAccessWithCallback invokes the lto.DeniedMemberAccess API asynchronously
func (client *Client) DeniedMemberAccessWithCallback(request *DeniedMemberAccessRequest, callback func(response *DeniedMemberAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeniedMemberAccessResponse
		var err error
		defer close(result)
		response, err = client.DeniedMemberAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeniedMemberAccessRequest is the request struct for api DeniedMemberAccess
type DeniedMemberAccessRequest struct {
	*requests.RpcRequest
	MemberAccountId string `position:"Query" name:"MemberAccountId"`
}

// DeniedMemberAccessResponse is the response struct for api DeniedMemberAccess
type DeniedMemberAccessResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeniedMemberAccessRequest creates a request to invoke DeniedMemberAccess API
func CreateDeniedMemberAccessRequest() (request *DeniedMemberAccessRequest) {
	request = &DeniedMemberAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DeniedMemberAccess", "", "")
	request.Method = requests.POST
	return
}

// CreateDeniedMemberAccessResponse creates a response to parse from DeniedMemberAccess response
func CreateDeniedMemberAccessResponse() (response *DeniedMemberAccessResponse) {
	response = &DeniedMemberAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
