package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivacyRule invokes the lto.ListPrivacyRule API synchronously
func (client *Client) ListPrivacyRule(request *ListPrivacyRuleRequest) (response *ListPrivacyRuleResponse, err error) {
	response = CreateListPrivacyRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivacyRuleWithChan invokes the lto.ListPrivacyRule API asynchronously
func (client *Client) ListPrivacyRuleWithChan(request *ListPrivacyRuleRequest) (<-chan *ListPrivacyRuleResponse, <-chan error) {
	responseChan := make(chan *ListPrivacyRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivacyRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivacyRuleWithCallback invokes the lto.ListPrivacyRule API asynchronously
func (client *Client) ListPrivacyRuleWithCallback(request *ListPrivacyRuleRequest, callback func(response *ListPrivacyRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivacyRuleResponse
		var err error
		defer close(result)
		response, err = client.ListPrivacyRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivacyRuleRequest is the request struct for api ListPrivacyRule
type ListPrivacyRuleRequest struct {
	*requests.RpcRequest
	Num  requests.Integer `position:"Query" name:"Num"`
	Size requests.Integer `position:"Query" name:"Size"`
}

// ListPrivacyRuleResponse is the response struct for api ListPrivacyRule
type ListPrivacyRuleResponse struct {
	*responses.BaseResponse
	Code           string                `json:"Code" xml:"Code"`
	HttpStatusCode int                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                `json:"Message" xml:"Message"`
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	Success        bool                  `json:"Success" xml:"Success"`
	Data           DataInListPrivacyRule `json:"Data" xml:"Data"`
}

// CreateListPrivacyRuleRequest creates a request to invoke ListPrivacyRule API
func CreateListPrivacyRuleRequest() (request *ListPrivacyRuleRequest) {
	request = &ListPrivacyRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListPrivacyRule", "", "")
	request.Method = requests.POST
	return
}

// CreateListPrivacyRuleResponse creates a response to parse from ListPrivacyRule response
func CreateListPrivacyRuleResponse() (response *ListPrivacyRuleResponse) {
	response = &ListPrivacyRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
