package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRouteRule invokes the lto.UpdateRouteRule API synchronously
func (client *Client) UpdateRouteRule(request *UpdateRouteRuleRequest) (response *UpdateRouteRuleResponse, err error) {
	response = CreateUpdateRouteRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRouteRuleWithChan invokes the lto.UpdateRouteRule API asynchronously
func (client *Client) UpdateRouteRuleWithChan(request *UpdateRouteRuleRequest) (<-chan *UpdateRouteRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateRouteRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRouteRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRouteRuleWithCallback invokes the lto.UpdateRouteRule API asynchronously
func (client *Client) UpdateRouteRuleWithCallback(request *UpdateRouteRuleRequest, callback func(response *UpdateRouteRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRouteRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateRouteRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRouteRuleRequest is the request struct for api UpdateRouteRule
type UpdateRouteRuleRequest struct {
	*requests.RpcRequest
	ContractTemplateId string `position:"Query" name:"ContractTemplateId"`
	ContractName       string `position:"Query" name:"ContractName"`
	PrivacyRuleId      string `position:"Query" name:"PrivacyRuleId"`
	Remark             string `position:"Query" name:"Remark"`
	BizChainId         string `position:"Query" name:"BizChainId"`
	InvokeType         string `position:"Query" name:"InvokeType"`
	RouteRuleId        string `position:"Query" name:"RouteRuleId"`
}

// UpdateRouteRuleResponse is the response struct for api UpdateRouteRule
type UpdateRouteRuleResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateRouteRuleRequest creates a request to invoke UpdateRouteRule API
func CreateUpdateRouteRuleRequest() (request *UpdateRouteRuleRequest) {
	request = &UpdateRouteRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "UpdateRouteRule", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRouteRuleResponse creates a response to parse from UpdateRouteRule response
func CreateUpdateRouteRuleResponse() (response *UpdateRouteRuleResponse) {
	response = &UpdateRouteRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
