package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetQueueAttributes invokes the mns_open.SetQueueAttributes API synchronously
func (client *Client) SetQueueAttributes(request *SetQueueAttributesRequest) (response *SetQueueAttributesResponse, err error) {
	response = CreateSetQueueAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// SetQueueAttributesWithChan invokes the mns_open.SetQueueAttributes API asynchronously
func (client *Client) SetQueueAttributesWithChan(request *SetQueueAttributesRequest) (<-chan *SetQueueAttributesResponse, <-chan error) {
	responseChan := make(chan *SetQueueAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetQueueAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetQueueAttributesWithCallback invokes the mns_open.SetQueueAttributes API asynchronously
func (client *Client) SetQueueAttributesWithCallback(request *SetQueueAttributesRequest, callback func(response *SetQueueAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetQueueAttributesResponse
		var err error
		defer close(result)
		response, err = client.SetQueueAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetQueueAttributesRequest is the request struct for api SetQueueAttributes
type SetQueueAttributesRequest struct {
	*requests.RpcRequest
	QueueName              string           `position:"Query" name:"QueueName"`
	MessageRetentionPeriod requests.Integer `position:"Query" name:"MessageRetentionPeriod"`
	EnableLogging          requests.Boolean `position:"Query" name:"EnableLogging"`
	VisibilityTimeout      requests.Integer `position:"Query" name:"VisibilityTimeout"`
	DelaySeconds           requests.Integer `position:"Query" name:"DelaySeconds"`
	MaximumMessageSize     requests.Integer `position:"Query" name:"MaximumMessageSize"`
	PollingWaitSeconds     requests.Integer `position:"Query" name:"PollingWaitSeconds"`
}

// SetQueueAttributesResponse is the response struct for api SetQueueAttributes
type SetQueueAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSetQueueAttributesRequest creates a request to invoke SetQueueAttributes API
func CreateSetQueueAttributesRequest() (request *SetQueueAttributesRequest) {
	request = &SetQueueAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "SetQueueAttributes", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetQueueAttributesResponse creates a response to parse from SetQueueAttributes response
func CreateSetQueueAttributesResponse() (response *SetQueueAttributesResponse) {
	response = &SetQueueAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
