package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcdpMaterial invokes the mpaas.DeleteMcdpMaterial API synchronously
func (client *Client) DeleteMcdpMaterial(request *DeleteMcdpMaterialRequest) (response *DeleteMcdpMaterialResponse, err error) {
	response = CreateDeleteMcdpMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcdpMaterialWithChan invokes the mpaas.DeleteMcdpMaterial API asynchronously
func (client *Client) DeleteMcdpMaterialWithChan(request *DeleteMcdpMaterialRequest) (<-chan *DeleteMcdpMaterialResponse, <-chan error) {
	responseChan := make(chan *DeleteMcdpMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcdpMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcdpMaterialWithCallback invokes the mpaas.DeleteMcdpMaterial API asynchronously
func (client *Client) DeleteMcdpMaterialWithCallback(request *DeleteMcdpMaterialRequest, callback func(response *DeleteMcdpMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcdpMaterialResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcdpMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcdpMaterialRequest is the request struct for api DeleteMcdpMaterial
type DeleteMcdpMaterialRequest struct {
	*requests.RpcRequest
	TenantId                                 string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpMaterialDeleteJsonStr string `position:"Body" name:"MpaasMappcenterMcdpMaterialDeleteJsonStr"`
	AppId                                    string `position:"Body" name:"AppId"`
	WorkspaceId                              string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcdpMaterialResponse is the response struct for api DeleteMcdpMaterial
type DeleteMcdpMaterialResponse struct {
	*responses.BaseResponse
	ResultMessage string                            `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                            `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                            `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMcdpMaterial `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMcdpMaterialRequest creates a request to invoke DeleteMcdpMaterial API
func CreateDeleteMcdpMaterialRequest() (request *DeleteMcdpMaterialRequest) {
	request = &DeleteMcdpMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcdpMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcdpMaterialResponse creates a response to parse from DeleteMcdpMaterial response
func CreateDeleteMcdpMaterialResponse() (response *DeleteMcdpMaterialResponse) {
	response = &DeleteMcdpMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
