package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcubeMiniApp invokes the mpaas.DeleteMcubeMiniApp API synchronously
func (client *Client) DeleteMcubeMiniApp(request *DeleteMcubeMiniAppRequest) (response *DeleteMcubeMiniAppResponse, err error) {
	response = CreateDeleteMcubeMiniAppResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcubeMiniAppWithChan invokes the mpaas.DeleteMcubeMiniApp API asynchronously
func (client *Client) DeleteMcubeMiniAppWithChan(request *DeleteMcubeMiniAppRequest) (<-chan *DeleteMcubeMiniAppResponse, <-chan error) {
	responseChan := make(chan *DeleteMcubeMiniAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcubeMiniApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcubeMiniAppWithCallback invokes the mpaas.DeleteMcubeMiniApp API asynchronously
func (client *Client) DeleteMcubeMiniAppWithCallback(request *DeleteMcubeMiniAppRequest, callback func(response *DeleteMcubeMiniAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcubeMiniAppResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcubeMiniApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcubeMiniAppRequest is the request struct for api DeleteMcubeMiniApp
type DeleteMcubeMiniAppRequest struct {
	*requests.RpcRequest
	H5Id        string `position:"Body" name:"H5Id"`
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcubeMiniAppResponse is the response struct for api DeleteMcubeMiniApp
type DeleteMcubeMiniAppResponse struct {
	*responses.BaseResponse
	ResultMessage    string           `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode       string           `json:"ResultCode" xml:"ResultCode"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	DeleteMiniResult DeleteMiniResult `json:"DeleteMiniResult" xml:"DeleteMiniResult"`
}

// CreateDeleteMcubeMiniAppRequest creates a request to invoke DeleteMcubeMiniApp API
func CreateDeleteMcubeMiniAppRequest() (request *DeleteMcubeMiniAppRequest) {
	request = &DeleteMcubeMiniAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcubeMiniApp", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcubeMiniAppResponse creates a response to parse from DeleteMcubeMiniApp response
func CreateDeleteMcubeMiniAppResponse() (response *DeleteMcubeMiniAppResponse) {
	response = &DeleteMcubeMiniAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
