package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserAppEnhanceProcessInMsa invokes the mpaas.GetUserAppEnhanceProcessInMsa API synchronously
func (client *Client) GetUserAppEnhanceProcessInMsa(request *GetUserAppEnhanceProcessInMsaRequest) (response *GetUserAppEnhanceProcessInMsaResponse, err error) {
	response = CreateGetUserAppEnhanceProcessInMsaResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserAppEnhanceProcessInMsaWithChan invokes the mpaas.GetUserAppEnhanceProcessInMsa API asynchronously
func (client *Client) GetUserAppEnhanceProcessInMsaWithChan(request *GetUserAppEnhanceProcessInMsaRequest) (<-chan *GetUserAppEnhanceProcessInMsaResponse, <-chan error) {
	responseChan := make(chan *GetUserAppEnhanceProcessInMsaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserAppEnhanceProcessInMsa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserAppEnhanceProcessInMsaWithCallback invokes the mpaas.GetUserAppEnhanceProcessInMsa API asynchronously
func (client *Client) GetUserAppEnhanceProcessInMsaWithCallback(request *GetUserAppEnhanceProcessInMsaRequest, callback func(response *GetUserAppEnhanceProcessInMsaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserAppEnhanceProcessInMsaResponse
		var err error
		defer close(result)
		response, err = client.GetUserAppEnhanceProcessInMsa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserAppEnhanceProcessInMsaRequest is the request struct for api GetUserAppEnhanceProcessInMsa
type GetUserAppEnhanceProcessInMsaRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          requests.Integer `position:"Body" name:"Id"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetUserAppEnhanceProcessInMsaResponse is the response struct for api GetUserAppEnhanceProcessInMsa
type GetUserAppEnhanceProcessInMsaResponse struct {
	*responses.BaseResponse
	ResultMessage string                                       `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                       `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                       `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInGetUserAppEnhanceProcessInMsa `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetUserAppEnhanceProcessInMsaRequest creates a request to invoke GetUserAppEnhanceProcessInMsa API
func CreateGetUserAppEnhanceProcessInMsaRequest() (request *GetUserAppEnhanceProcessInMsaRequest) {
	request = &GetUserAppEnhanceProcessInMsaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetUserAppEnhanceProcessInMsa", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserAppEnhanceProcessInMsaResponse creates a response to parse from GetUserAppEnhanceProcessInMsa response
func CreateGetUserAppEnhanceProcessInMsaResponse() (response *GetUserAppEnhanceProcessInMsaResponse) {
	response = &GetUserAppEnhanceProcessInMsaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
