package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenApiAddActiveCode invokes the mpaas.OpenApiAddActiveCode API synchronously
func (client *Client) OpenApiAddActiveCode(request *OpenApiAddActiveCodeRequest) (response *OpenApiAddActiveCodeResponse, err error) {
	response = CreateOpenApiAddActiveCodeResponse()
	err = client.DoAction(request, response)
	return
}

// OpenApiAddActiveCodeWithChan invokes the mpaas.OpenApiAddActiveCode API asynchronously
func (client *Client) OpenApiAddActiveCodeWithChan(request *OpenApiAddActiveCodeRequest) (<-chan *OpenApiAddActiveCodeResponse, <-chan error) {
	responseChan := make(chan *OpenApiAddActiveCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenApiAddActiveCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenApiAddActiveCodeWithCallback invokes the mpaas.OpenApiAddActiveCode API asynchronously
func (client *Client) OpenApiAddActiveCodeWithCallback(request *OpenApiAddActiveCodeRequest, callback func(response *OpenApiAddActiveCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenApiAddActiveCodeResponse
		var err error
		defer close(result)
		response, err = client.OpenApiAddActiveCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenApiAddActiveCodeRequest is the request struct for api OpenApiAddActiveCode
type OpenApiAddActiveCodeRequest struct {
	*requests.RpcRequest
	TenantId                                string `position:"Body" name:"TenantId"`
	MpaasMqcpOpenApiAddActiveCodeReqJsonStr string `position:"Body" name:"MpaasMqcpOpenApiAddActiveCodeReqJsonStr"`
	AppId                                   string `position:"Body" name:"AppId"`
	WorkspaceId                             string `position:"Body" name:"WorkspaceId"`
}

// OpenApiAddActiveCodeResponse is the response struct for api OpenApiAddActiveCode
type OpenApiAddActiveCodeResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
}

// CreateOpenApiAddActiveCodeRequest creates a request to invoke OpenApiAddActiveCode API
func CreateOpenApiAddActiveCodeRequest() (request *OpenApiAddActiveCodeRequest) {
	request = &OpenApiAddActiveCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "OpenApiAddActiveCode", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenApiAddActiveCodeResponse creates a response to parse from OpenApiAddActiveCode response
func CreateOpenApiAddActiveCodeResponse() (response *OpenApiAddActiveCodeResponse) {
	response = &OpenApiAddActiveCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
