package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPushAnalysisCoreIndex invokes the mpaas.QueryPushAnalysisCoreIndex API synchronously
func (client *Client) QueryPushAnalysisCoreIndex(request *QueryPushAnalysisCoreIndexRequest) (response *QueryPushAnalysisCoreIndexResponse, err error) {
	response = CreateQueryPushAnalysisCoreIndexResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPushAnalysisCoreIndexWithChan invokes the mpaas.QueryPushAnalysisCoreIndex API asynchronously
func (client *Client) QueryPushAnalysisCoreIndexWithChan(request *QueryPushAnalysisCoreIndexRequest) (<-chan *QueryPushAnalysisCoreIndexResponse, <-chan error) {
	responseChan := make(chan *QueryPushAnalysisCoreIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPushAnalysisCoreIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPushAnalysisCoreIndexWithCallback invokes the mpaas.QueryPushAnalysisCoreIndex API asynchronously
func (client *Client) QueryPushAnalysisCoreIndexWithCallback(request *QueryPushAnalysisCoreIndexRequest, callback func(response *QueryPushAnalysisCoreIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPushAnalysisCoreIndexResponse
		var err error
		defer close(result)
		response, err = client.QueryPushAnalysisCoreIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPushAnalysisCoreIndexRequest is the request struct for api QueryPushAnalysisCoreIndex
type QueryPushAnalysisCoreIndexRequest struct {
	*requests.RpcRequest
	Channel     string           `position:"Body" name:"Channel"`
	StartTime   requests.Integer `position:"Body" name:"StartTime"`
	Type        string           `position:"Body" name:"Type"`
	Platform    string           `position:"Body" name:"Platform"`
	TaskId      string           `position:"Body" name:"TaskId"`
	EndTime     requests.Integer `position:"Body" name:"EndTime"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// QueryPushAnalysisCoreIndexResponse is the response struct for api QueryPushAnalysisCoreIndex
type QueryPushAnalysisCoreIndexResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateQueryPushAnalysisCoreIndexRequest creates a request to invoke QueryPushAnalysisCoreIndex API
func CreateQueryPushAnalysisCoreIndexRequest() (request *QueryPushAnalysisCoreIndexRequest) {
	request = &QueryPushAnalysisCoreIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryPushAnalysisCoreIndex", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPushAnalysisCoreIndexResponse creates a response to parse from QueryPushAnalysisCoreIndex response
func CreateQueryPushAnalysisCoreIndexResponse() (response *QueryPushAnalysisCoreIndexResponse) {
	response = &QueryPushAnalysisCoreIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
