package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddAuthPolicy invokes the mse.AddAuthPolicy API synchronously
func (client *Client) AddAuthPolicy(request *AddAuthPolicyRequest) (response *AddAuthPolicyResponse, err error) {
	response = CreateAddAuthPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// AddAuthPolicyWithChan invokes the mse.AddAuthPolicy API asynchronously
func (client *Client) AddAuthPolicyWithChan(request *AddAuthPolicyRequest) (<-chan *AddAuthPolicyResponse, <-chan error) {
	responseChan := make(chan *AddAuthPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddAuthPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddAuthPolicyWithCallback invokes the mse.AddAuthPolicy API asynchronously
func (client *Client) AddAuthPolicyWithCallback(request *AddAuthPolicyRequest, callback func(response *AddAuthPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddAuthPolicyResponse
		var err error
		defer close(result)
		response, err = client.AddAuthPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddAuthPolicyRequest is the request struct for api AddAuthPolicy
type AddAuthPolicyRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	AuthRule       string           `position:"Query" name:"AuthRule"`
	Source         string           `position:"Query" name:"Source"`
	AuthType       requests.Integer `position:"Query" name:"AuthType"`
	Protocol       string           `position:"Query" name:"Protocol"`
	Enable         string           `position:"Query" name:"Enable"`
	K8sNamespace   string           `position:"Query" name:"K8sNamespace"`
	AppId          string           `position:"Query" name:"AppId"`
	Name           string           `position:"Query" name:"Name"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	Region         string           `position:"Query" name:"Region"`
}

// AddAuthPolicyResponse is the response struct for api AddAuthPolicy
type AddAuthPolicyResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddAuthPolicyRequest creates a request to invoke AddAuthPolicy API
func CreateAddAuthPolicyRequest() (request *AddAuthPolicyRequest) {
	request = &AddAuthPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddAuthPolicy", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddAuthPolicyResponse creates a response to parse from AddAuthPolicy response
func CreateAddAuthPolicyResponse() (response *AddAuthPolicyResponse) {
	response = &AddAuthPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
