package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFlowRule invokes the mse.CreateFlowRule API synchronously
func (client *Client) CreateFlowRule(request *CreateFlowRuleRequest) (response *CreateFlowRuleResponse, err error) {
	response = CreateCreateFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFlowRuleWithChan invokes the mse.CreateFlowRule API asynchronously
func (client *Client) CreateFlowRuleWithChan(request *CreateFlowRuleRequest) (<-chan *CreateFlowRuleResponse, <-chan error) {
	responseChan := make(chan *CreateFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFlowRuleWithCallback invokes the mse.CreateFlowRule API asynchronously
func (client *Client) CreateFlowRuleWithCallback(request *CreateFlowRuleRequest, callback func(response *CreateFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFlowRuleRequest is the request struct for api CreateFlowRule
type CreateFlowRuleRequest struct {
	*requests.RpcRequest
	MseSessionId      string           `position:"Query" name:"MseSessionId"`
	Threshold         requests.Integer `position:"Query" name:"Threshold"`
	AppName           string           `position:"Query" name:"AppName"`
	Enable            requests.Boolean `position:"Query" name:"Enable"`
	Resource          string           `position:"Query" name:"Resource"`
	MaxQueueingTimeMs requests.Integer `position:"Query" name:"MaxQueueingTimeMs"`
	ControlBehavior   requests.Integer `position:"Query" name:"ControlBehavior"`
	ResourceType      requests.Integer `position:"Query" name:"ResourceType"`
	AppId             string           `position:"Query" name:"AppId"`
	Namespace         string           `position:"Query" name:"Namespace"`
	AcceptLanguage    string           `position:"Query" name:"AcceptLanguage"`
}

// CreateFlowRuleResponse is the response struct for api CreateFlowRule
type CreateFlowRuleResponse struct {
	*responses.BaseResponse
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      DataInCreateFlowRule `json:"Data" xml:"Data"`
}

// CreateCreateFlowRuleRequest creates a request to invoke CreateFlowRule API
func CreateCreateFlowRuleRequest() (request *CreateFlowRuleRequest) {
	request = &CreateFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateFlowRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFlowRuleResponse creates a response to parse from CreateFlowRule response
func CreateCreateFlowRuleResponse() (response *CreateFlowRuleResponse) {
	response = &CreateFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
