package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceMethodPage invokes the mse.GetServiceMethodPage API synchronously
func (client *Client) GetServiceMethodPage(request *GetServiceMethodPageRequest) (response *GetServiceMethodPageResponse, err error) {
	response = CreateGetServiceMethodPageResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceMethodPageWithChan invokes the mse.GetServiceMethodPage API asynchronously
func (client *Client) GetServiceMethodPageWithChan(request *GetServiceMethodPageRequest) (<-chan *GetServiceMethodPageResponse, <-chan error) {
	responseChan := make(chan *GetServiceMethodPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceMethodPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceMethodPageWithCallback invokes the mse.GetServiceMethodPage API asynchronously
func (client *Client) GetServiceMethodPageWithCallback(request *GetServiceMethodPageRequest, callback func(response *GetServiceMethodPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceMethodPageResponse
		var err error
		defer close(result)
		response, err = client.GetServiceMethodPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceMethodPageRequest is the request struct for api GetServiceMethodPage
type GetServiceMethodPageRequest struct {
	*requests.RpcRequest
	MseSessionId     string           `position:"Query" name:"MseSessionId"`
	ServiceGroup     string           `position:"Query" name:"ServiceGroup"`
	Path             string           `position:"Query" name:"Path"`
	AppName          string           `position:"Query" name:"AppName"`
	Ip               string           `position:"Query" name:"Ip"`
	ServiceVersion   string           `position:"Query" name:"ServiceVersion"`
	Name             string           `position:"Query" name:"Name"`
	Region           string           `position:"Query" name:"Region"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	ServiceName      string           `position:"Query" name:"ServiceName"`
	ServiceType      string           `position:"Query" name:"ServiceType"`
	AppId            string           `position:"Query" name:"AppId"`
	Namespace        string           `position:"Query" name:"Namespace"`
	AcceptLanguage   string           `position:"Query" name:"AcceptLanguage"`
	MethodController string           `position:"Query" name:"MethodController"`
}

// GetServiceMethodPageResponse is the response struct for api GetServiceMethodPage
type GetServiceMethodPageResponse struct {
	*responses.BaseResponse
	Success        bool                       `json:"Success" xml:"Success"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                     `json:"Message" xml:"Message"`
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Code           int                        `json:"Code" xml:"Code"`
	Data           DataInGetServiceMethodPage `json:"Data" xml:"Data"`
}

// CreateGetServiceMethodPageRequest creates a request to invoke GetServiceMethodPage API
func CreateGetServiceMethodPageRequest() (request *GetServiceMethodPageRequest) {
	request = &GetServiceMethodPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetServiceMethodPage", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceMethodPageResponse creates a response to parse from GetServiceMethodPage response
func CreateGetServiceMethodPageResponse() (response *GetServiceMethodPageResponse) {
	response = &GetServiceMethodPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
