package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayAuthConsumerResource invokes the mse.ListGatewayAuthConsumerResource API synchronously
func (client *Client) ListGatewayAuthConsumerResource(request *ListGatewayAuthConsumerResourceRequest) (response *ListGatewayAuthConsumerResourceResponse, err error) {
	response = CreateListGatewayAuthConsumerResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayAuthConsumerResourceWithChan invokes the mse.ListGatewayAuthConsumerResource API asynchronously
func (client *Client) ListGatewayAuthConsumerResourceWithChan(request *ListGatewayAuthConsumerResourceRequest) (<-chan *ListGatewayAuthConsumerResourceResponse, <-chan error) {
	responseChan := make(chan *ListGatewayAuthConsumerResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayAuthConsumerResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayAuthConsumerResourceWithCallback invokes the mse.ListGatewayAuthConsumerResource API asynchronously
func (client *Client) ListGatewayAuthConsumerResourceWithCallback(request *ListGatewayAuthConsumerResourceRequest, callback func(response *ListGatewayAuthConsumerResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayAuthConsumerResourceResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayAuthConsumerResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayAuthConsumerResourceRequest is the request struct for api ListGatewayAuthConsumerResource
type ListGatewayAuthConsumerResourceRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	ConsumerId      requests.Integer `position:"Query" name:"ConsumerId"`
	PageNum         string           `position:"Query" name:"PageNum"`
	PageSize        string           `position:"Query" name:"PageSize"`
	RouteName       string           `position:"Query" name:"RouteName"`
	ResourceStatus  requests.Boolean `position:"Query" name:"ResourceStatus"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayAuthConsumerResourceResponse is the response struct for api ListGatewayAuthConsumerResource
type ListGatewayAuthConsumerResourceResponse struct {
	*responses.BaseResponse
	RequestId      string                                `json:"RequestId" xml:"RequestId"`
	Success        bool                                  `json:"Success" xml:"Success"`
	Code           int                                   `json:"Code" xml:"Code"`
	ErrorCode      string                                `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int                                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                                `json:"Message" xml:"Message"`
	DynamicCode    string                                `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string                                `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           DataInListGatewayAuthConsumerResource `json:"Data" xml:"Data"`
}

// CreateListGatewayAuthConsumerResourceRequest creates a request to invoke ListGatewayAuthConsumerResource API
func CreateListGatewayAuthConsumerResourceRequest() (request *ListGatewayAuthConsumerResourceRequest) {
	request = &ListGatewayAuthConsumerResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayAuthConsumerResource", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayAuthConsumerResourceResponse creates a response to parse from ListGatewayAuthConsumerResource response
func CreateListGatewayAuthConsumerResourceResponse() (response *ListGatewayAuthConsumerResourceResponse) {
	response = &ListGatewayAuthConsumerResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
