package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayCircuitBreakerRule invokes the mse.UpdateGatewayCircuitBreakerRule API synchronously
func (client *Client) UpdateGatewayCircuitBreakerRule(request *UpdateGatewayCircuitBreakerRuleRequest) (response *UpdateGatewayCircuitBreakerRuleResponse, err error) {
	response = CreateUpdateGatewayCircuitBreakerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayCircuitBreakerRuleWithChan invokes the mse.UpdateGatewayCircuitBreakerRule API asynchronously
func (client *Client) UpdateGatewayCircuitBreakerRuleWithChan(request *UpdateGatewayCircuitBreakerRuleRequest) (<-chan *UpdateGatewayCircuitBreakerRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayCircuitBreakerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayCircuitBreakerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayCircuitBreakerRuleWithCallback invokes the mse.UpdateGatewayCircuitBreakerRule API asynchronously
func (client *Client) UpdateGatewayCircuitBreakerRuleWithCallback(request *UpdateGatewayCircuitBreakerRuleRequest, callback func(response *UpdateGatewayCircuitBreakerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayCircuitBreakerRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayCircuitBreakerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayCircuitBreakerRuleRequest is the request struct for api UpdateGatewayCircuitBreakerRule
type UpdateGatewayCircuitBreakerRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	MaxAllowedMs        requests.Integer `position:"Query" name:"MaxAllowedMs"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	MinRequestAmount    requests.Integer `position:"Query" name:"MinRequestAmount"`
	Id                  requests.Integer `position:"Query" name:"Id"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	TriggerRatio        requests.Integer `position:"Query" name:"TriggerRatio"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	StatDurationSec     requests.Integer `position:"Query" name:"StatDurationSec"`
	RecoveryTimeoutSec  requests.Integer `position:"Query" name:"RecoveryTimeoutSec"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
	Strategy            requests.Integer `position:"Query" name:"Strategy"`
}

// UpdateGatewayCircuitBreakerRuleResponse is the response struct for api UpdateGatewayCircuitBreakerRule
type UpdateGatewayCircuitBreakerRuleResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateGatewayCircuitBreakerRule `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayCircuitBreakerRuleRequest creates a request to invoke UpdateGatewayCircuitBreakerRule API
func CreateUpdateGatewayCircuitBreakerRuleRequest() (request *UpdateGatewayCircuitBreakerRuleRequest) {
	request = &UpdateGatewayCircuitBreakerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayCircuitBreakerRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayCircuitBreakerRuleResponse creates a response to parse from UpdateGatewayCircuitBreakerRule response
func CreateUpdateGatewayCircuitBreakerRuleResponse() (response *UpdateGatewayCircuitBreakerRuleResponse) {
	response = &UpdateGatewayCircuitBreakerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
