package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateLicense invokes the mseap.ActivateLicense API synchronously
func (client *Client) ActivateLicense(request *ActivateLicenseRequest) (response *ActivateLicenseResponse, err error) {
	response = CreateActivateLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateLicenseWithChan invokes the mseap.ActivateLicense API asynchronously
func (client *Client) ActivateLicenseWithChan(request *ActivateLicenseRequest) (<-chan *ActivateLicenseResponse, <-chan error) {
	responseChan := make(chan *ActivateLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateLicenseWithCallback invokes the mseap.ActivateLicense API asynchronously
func (client *Client) ActivateLicenseWithCallback(request *ActivateLicenseRequest, callback func(response *ActivateLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateLicenseResponse
		var err error
		defer close(result)
		response, err = client.ActivateLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateLicenseRequest is the request struct for api ActivateLicense
type ActivateLicenseRequest struct {
	*requests.RpcRequest
	LicenseNo        string `position:"Query" name:"LicenseNo"`
	BizType          string `position:"Query" name:"BizType"`
	LicensePublisher string `position:"Query" name:"LicensePublisher"`
	BizId            string `position:"Query" name:"BizId"`
	LicenseCode      string `position:"Query" name:"LicenseCode"`
}

// ActivateLicenseResponse is the response struct for api ActivateLicense
type ActivateLicenseResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateActivateLicenseRequest creates a request to invoke ActivateLicense API
func CreateActivateLicenseRequest() (request *ActivateLicenseRequest) {
	request = &ActivateLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "ActivateLicense", "", "")
	request.Method = requests.POST
	return
}

// CreateActivateLicenseResponse creates a response to parse from ActivateLicense response
func CreateActivateLicenseResponse() (response *ActivateLicenseResponse) {
	response = &ActivateLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
