package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyDataFlowAutoRefresh invokes the nas.ApplyDataFlowAutoRefresh API synchronously
func (client *Client) ApplyDataFlowAutoRefresh(request *ApplyDataFlowAutoRefreshRequest) (response *ApplyDataFlowAutoRefreshResponse, err error) {
	response = CreateApplyDataFlowAutoRefreshResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyDataFlowAutoRefreshWithChan invokes the nas.ApplyDataFlowAutoRefresh API asynchronously
func (client *Client) ApplyDataFlowAutoRefreshWithChan(request *ApplyDataFlowAutoRefreshRequest) (<-chan *ApplyDataFlowAutoRefreshResponse, <-chan error) {
	responseChan := make(chan *ApplyDataFlowAutoRefreshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyDataFlowAutoRefresh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyDataFlowAutoRefreshWithCallback invokes the nas.ApplyDataFlowAutoRefresh API asynchronously
func (client *Client) ApplyDataFlowAutoRefreshWithCallback(request *ApplyDataFlowAutoRefreshRequest, callback func(response *ApplyDataFlowAutoRefreshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyDataFlowAutoRefreshResponse
		var err error
		defer close(result)
		response, err = client.ApplyDataFlowAutoRefresh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyDataFlowAutoRefreshRequest is the request struct for api ApplyDataFlowAutoRefresh
type ApplyDataFlowAutoRefreshRequest struct {
	*requests.RpcRequest
	AutoRefreshPolicy   string                                  `position:"Query" name:"AutoRefreshPolicy"`
	ClientToken         string                                  `position:"Query" name:"ClientToken"`
	AutoRefreshs        *[]ApplyDataFlowAutoRefreshAutoRefreshs `position:"Query" name:"AutoRefreshs"  type:"Repeated"`
	FileSystemId        string                                  `position:"Query" name:"FileSystemId"`
	DryRun              requests.Boolean                        `position:"Query" name:"DryRun"`
	DataFlowId          string                                  `position:"Query" name:"DataFlowId"`
	AutoRefreshInterval requests.Integer                        `position:"Query" name:"AutoRefreshInterval"`
}

// ApplyDataFlowAutoRefreshAutoRefreshs is a repeated param struct in ApplyDataFlowAutoRefreshRequest
type ApplyDataFlowAutoRefreshAutoRefreshs struct {
	RefreshPath string `name:"RefreshPath"`
}

// ApplyDataFlowAutoRefreshResponse is the response struct for api ApplyDataFlowAutoRefresh
type ApplyDataFlowAutoRefreshResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyDataFlowAutoRefreshRequest creates a request to invoke ApplyDataFlowAutoRefresh API
func CreateApplyDataFlowAutoRefreshRequest() (request *ApplyDataFlowAutoRefreshRequest) {
	request = &ApplyDataFlowAutoRefreshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ApplyDataFlowAutoRefresh", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyDataFlowAutoRefreshResponse creates a response to parse from ApplyDataFlowAutoRefresh response
func CreateApplyDataFlowAutoRefreshResponse() (response *ApplyDataFlowAutoRefreshResponse) {
	response = &ApplyDataFlowAutoRefreshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
