package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTransitRouterFlowTopN invokes the nis.GetTransitRouterFlowTopN API synchronously
func (client *Client) GetTransitRouterFlowTopN(request *GetTransitRouterFlowTopNRequest) (response *GetTransitRouterFlowTopNResponse, err error) {
	response = CreateGetTransitRouterFlowTopNResponse()
	err = client.DoAction(request, response)
	return
}

// GetTransitRouterFlowTopNWithChan invokes the nis.GetTransitRouterFlowTopN API asynchronously
func (client *Client) GetTransitRouterFlowTopNWithChan(request *GetTransitRouterFlowTopNRequest) (<-chan *GetTransitRouterFlowTopNResponse, <-chan error) {
	responseChan := make(chan *GetTransitRouterFlowTopNResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTransitRouterFlowTopN(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTransitRouterFlowTopNWithCallback invokes the nis.GetTransitRouterFlowTopN API asynchronously
func (client *Client) GetTransitRouterFlowTopNWithCallback(request *GetTransitRouterFlowTopNRequest, callback func(response *GetTransitRouterFlowTopNResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTransitRouterFlowTopNResponse
		var err error
		defer close(result)
		response, err = client.GetTransitRouterFlowTopN(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTransitRouterFlowTopNRequest is the request struct for api GetTransitRouterFlowTopN
type GetTransitRouterFlowTopNRequest struct {
	*requests.RpcRequest
	OtherPort         string           `position:"Query" name:"OtherPort"`
	TopN              requests.Integer `position:"Query" name:"TopN"`
	Protocol          string           `position:"Query" name:"Protocol"`
	ThisIp            string           `position:"Query" name:"ThisIp"`
	OtherIp           string           `position:"Query" name:"OtherIp"`
	BandwithPackageId string           `position:"Query" name:"BandwithPackageId"`
	OrderBy           string           `position:"Query" name:"OrderBy"`
	Sort              string           `position:"Query" name:"Sort"`
	UseMultiAccount   requests.Boolean `position:"Query" name:"UseMultiAccount"`
	ThisRegion        string           `position:"Query" name:"ThisRegion"`
	CenId             string           `position:"Query" name:"CenId"`
	ThisPort          string           `position:"Query" name:"ThisPort"`
	Direction         string           `position:"Query" name:"Direction"`
	OtherRegion       string           `position:"Query" name:"OtherRegion"`
	EndTime           requests.Integer `position:"Query" name:"EndTime"`
	BeginTime         requests.Integer `position:"Query" name:"BeginTime"`
	GroupBy           string           `position:"Query" name:"GroupBy"`
	AccountIds        *[]string        `position:"Query" name:"AccountIds"  type:"Json"`
}

// GetTransitRouterFlowTopNResponse is the response struct for api GetTransitRouterFlowTopN
type GetTransitRouterFlowTopNResponse struct {
	*responses.BaseResponse
	RequestId             string          `json:"RequestId" xml:"RequestId"`
	TransitRouterFlowTopN []TrFlowlogTopN `json:"TransitRouterFlowTopN" xml:"TransitRouterFlowTopN"`
}

// CreateGetTransitRouterFlowTopNRequest creates a request to invoke GetTransitRouterFlowTopN API
func CreateGetTransitRouterFlowTopNRequest() (request *GetTransitRouterFlowTopNRequest) {
	request = &GetTransitRouterFlowTopNRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetTransitRouterFlowTopN", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTransitRouterFlowTopNResponse creates a response to parse from GetTransitRouterFlowTopN response
func CreateGetTransitRouterFlowTopNResponse() (response *GetTransitRouterFlowTopNResponse) {
	response = &GetTransitRouterFlowTopNResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
