package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignOperator invokes the oam.AssignOperator API synchronously
// api document: https://help.aliyun.com/api/oam/assignoperator.html
func (client *Client) AssignOperator(request *AssignOperatorRequest) (response *AssignOperatorResponse, err error) {
	response = CreateAssignOperatorResponse()
	err = client.DoAction(request, response)
	return
}

// AssignOperatorWithChan invokes the oam.AssignOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/assignoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignOperatorWithChan(request *AssignOperatorRequest) (<-chan *AssignOperatorResponse, <-chan error) {
	responseChan := make(chan *AssignOperatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignOperator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignOperatorWithCallback invokes the oam.AssignOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/assignoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignOperatorWithCallback(request *AssignOperatorRequest, callback func(response *AssignOperatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignOperatorResponse
		var err error
		defer close(result)
		response, err = client.AssignOperator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignOperatorRequest is the request struct for api AssignOperator
type AssignOperatorRequest struct {
	*requests.RpcRequest
	OperatorUserName string `position:"Query" name:"OperatorUserName"`
	OperatorId       string `position:"Query" name:"OperatorId"`
	OperatorType     string `position:"Query" name:"OperatorType"`
}

// AssignOperatorResponse is the response struct for api AssignOperator
type AssignOperatorResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateAssignOperatorRequest creates a request to invoke AssignOperator API
func CreateAssignOperatorRequest() (request *AssignOperatorRequest) {
	request = &AssignOperatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "AssignOperator", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignOperatorResponse creates a response to parse from AssignOperator response
func CreateAssignOperatorResponse() (response *AssignOperatorResponse) {
	response = &AssignOperatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
