package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRdsPostgreSQLDataSource invokes the oceanbasepro.CreateRdsPostgreSQLDataSource API synchronously
func (client *Client) CreateRdsPostgreSQLDataSource(request *CreateRdsPostgreSQLDataSourceRequest) (response *CreateRdsPostgreSQLDataSourceResponse, err error) {
	response = CreateCreateRdsPostgreSQLDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRdsPostgreSQLDataSourceWithChan invokes the oceanbasepro.CreateRdsPostgreSQLDataSource API asynchronously
func (client *Client) CreateRdsPostgreSQLDataSourceWithChan(request *CreateRdsPostgreSQLDataSourceRequest) (<-chan *CreateRdsPostgreSQLDataSourceResponse, <-chan error) {
	responseChan := make(chan *CreateRdsPostgreSQLDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRdsPostgreSQLDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRdsPostgreSQLDataSourceWithCallback invokes the oceanbasepro.CreateRdsPostgreSQLDataSource API asynchronously
func (client *Client) CreateRdsPostgreSQLDataSourceWithCallback(request *CreateRdsPostgreSQLDataSourceRequest, callback func(response *CreateRdsPostgreSQLDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRdsPostgreSQLDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateRdsPostgreSQLDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRdsPostgreSQLDataSourceRequest is the request struct for api CreateRdsPostgreSQLDataSource
type CreateRdsPostgreSQLDataSourceRequest struct {
	*requests.RpcRequest
	Description  string `position:"Body" name:"Description"`
	Password     string `position:"Body" name:"Password"`
	InstanceId   string `position:"Body" name:"InstanceId"`
	DatabaseName string `position:"Body" name:"DatabaseName"`
	Name         string `position:"Body" name:"Name"`
	UserName     string `position:"Body" name:"UserName"`
}

// CreateRdsPostgreSQLDataSourceResponse is the response struct for api CreateRdsPostgreSQLDataSource
type CreateRdsPostgreSQLDataSourceResponse struct {
	*responses.BaseResponse
}

// CreateCreateRdsPostgreSQLDataSourceRequest creates a request to invoke CreateRdsPostgreSQLDataSource API
func CreateCreateRdsPostgreSQLDataSourceRequest() (request *CreateRdsPostgreSQLDataSourceRequest) {
	request = &CreateRdsPostgreSQLDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateRdsPostgreSQLDataSource", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRdsPostgreSQLDataSourceResponse creates a response to parse from CreateRdsPostgreSQLDataSource response
func CreateCreateRdsPostgreSQLDataSourceResponse() (response *CreateRdsPostgreSQLDataSourceResponse) {
	response = &CreateRdsPostgreSQLDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
