package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOasSQLHistoryList invokes the oceanbasepro.DescribeOasSQLHistoryList API synchronously
func (client *Client) DescribeOasSQLHistoryList(request *DescribeOasSQLHistoryListRequest) (response *DescribeOasSQLHistoryListResponse, err error) {
	response = CreateDescribeOasSQLHistoryListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOasSQLHistoryListWithChan invokes the oceanbasepro.DescribeOasSQLHistoryList API asynchronously
func (client *Client) DescribeOasSQLHistoryListWithChan(request *DescribeOasSQLHistoryListRequest) (<-chan *DescribeOasSQLHistoryListResponse, <-chan error) {
	responseChan := make(chan *DescribeOasSQLHistoryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOasSQLHistoryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOasSQLHistoryListWithCallback invokes the oceanbasepro.DescribeOasSQLHistoryList API asynchronously
func (client *Client) DescribeOasSQLHistoryListWithCallback(request *DescribeOasSQLHistoryListRequest, callback func(response *DescribeOasSQLHistoryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOasSQLHistoryListResponse
		var err error
		defer close(result)
		response, err = client.DescribeOasSQLHistoryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOasSQLHistoryListRequest is the request struct for api DescribeOasSQLHistoryList
type DescribeOasSQLHistoryListRequest struct {
	*requests.RpcRequest
	StartTime      string           `position:"Body" name:"StartTime"`
	DynamicSql     requests.Boolean `position:"Body" name:"DynamicSql"`
	TenantId       string           `position:"Body" name:"TenantId"`
	SqlId          string           `position:"Body" name:"SqlId"`
	EndTime        string           `position:"Body" name:"EndTime"`
	NodeIp         string           `position:"Body" name:"NodeIp"`
	InstanceId     string           `position:"Body" name:"InstanceId"`
	DbName         string           `position:"Body" name:"DbName"`
	AcceptLanguage string           `position:"Body" name:"AcceptLanguage"`
}

// DescribeOasSQLHistoryListResponse is the response struct for api DescribeOasSQLHistoryList
type DescribeOasSQLHistoryListResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Data      []DataItemInDescribeOasSQLHistoryList `json:"Data" xml:"Data"`
}

// CreateDescribeOasSQLHistoryListRequest creates a request to invoke DescribeOasSQLHistoryList API
func CreateDescribeOasSQLHistoryListRequest() (request *DescribeOasSQLHistoryListRequest) {
	request = &DescribeOasSQLHistoryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOasSQLHistoryList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOasSQLHistoryListResponse creates a response to parse from DescribeOasSQLHistoryList response
func CreateDescribeOasSQLHistoryListResponse() (response *DescribeOasSQLHistoryListResponse) {
	response = &DescribeOasSQLHistoryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
