package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantSecurityIpGroups invokes the oceanbasepro.DescribeTenantSecurityIpGroups API synchronously
func (client *Client) DescribeTenantSecurityIpGroups(request *DescribeTenantSecurityIpGroupsRequest) (response *DescribeTenantSecurityIpGroupsResponse, err error) {
	response = CreateDescribeTenantSecurityIpGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantSecurityIpGroupsWithChan invokes the oceanbasepro.DescribeTenantSecurityIpGroups API asynchronously
func (client *Client) DescribeTenantSecurityIpGroupsWithChan(request *DescribeTenantSecurityIpGroupsRequest) (<-chan *DescribeTenantSecurityIpGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantSecurityIpGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantSecurityIpGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantSecurityIpGroupsWithCallback invokes the oceanbasepro.DescribeTenantSecurityIpGroups API asynchronously
func (client *Client) DescribeTenantSecurityIpGroupsWithCallback(request *DescribeTenantSecurityIpGroupsRequest, callback func(response *DescribeTenantSecurityIpGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantSecurityIpGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantSecurityIpGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantSecurityIpGroupsRequest is the request struct for api DescribeTenantSecurityIpGroups
type DescribeTenantSecurityIpGroupsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeTenantSecurityIpGroupsResponse is the response struct for api DescribeTenantSecurityIpGroups
type DescribeTenantSecurityIpGroupsResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int                    `json:"TotalCount" xml:"TotalCount"`
	SecurityIpGroups []SecurityIpGroupsItem `json:"SecurityIpGroups" xml:"SecurityIpGroups"`
}

// CreateDescribeTenantSecurityIpGroupsRequest creates a request to invoke DescribeTenantSecurityIpGroups API
func CreateDescribeTenantSecurityIpGroupsRequest() (request *DescribeTenantSecurityIpGroupsRequest) {
	request = &DescribeTenantSecurityIpGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantSecurityIpGroups", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantSecurityIpGroupsResponse creates a response to parse from DescribeTenantSecurityIpGroups response
func CreateDescribeTenantSecurityIpGroupsResponse() (response *DescribeTenantSecurityIpGroupsResponse) {
	response = &DescribeTenantSecurityIpGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
