package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectModifyRecords invokes the oceanbasepro.ListProjectModifyRecords API synchronously
func (client *Client) ListProjectModifyRecords(request *ListProjectModifyRecordsRequest) (response *ListProjectModifyRecordsResponse, err error) {
	response = CreateListProjectModifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectModifyRecordsWithChan invokes the oceanbasepro.ListProjectModifyRecords API asynchronously
func (client *Client) ListProjectModifyRecordsWithChan(request *ListProjectModifyRecordsRequest) (<-chan *ListProjectModifyRecordsResponse, <-chan error) {
	responseChan := make(chan *ListProjectModifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectModifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectModifyRecordsWithCallback invokes the oceanbasepro.ListProjectModifyRecords API asynchronously
func (client *Client) ListProjectModifyRecordsWithCallback(request *ListProjectModifyRecordsRequest, callback func(response *ListProjectModifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectModifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListProjectModifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectModifyRecordsRequest is the request struct for api ListProjectModifyRecords
type ListProjectModifyRecordsRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// ListProjectModifyRecordsResponse is the response struct for api ListProjectModifyRecords
type ListProjectModifyRecordsResponse struct {
	*responses.BaseResponse
}

// CreateListProjectModifyRecordsRequest creates a request to invoke ListProjectModifyRecords API
func CreateListProjectModifyRecordsRequest() (request *ListProjectModifyRecordsRequest) {
	request = &ListProjectModifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ListProjectModifyRecords", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProjectModifyRecordsResponse creates a response to parse from ListProjectModifyRecords response
func CreateListProjectModifyRecordsResponse() (response *ListProjectModifyRecordsResponse) {
	response = &ListProjectModifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
