package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWorkerInstances invokes the oceanbasepro.ListWorkerInstances API synchronously
func (client *Client) ListWorkerInstances(request *ListWorkerInstancesRequest) (response *ListWorkerInstancesResponse, err error) {
	response = CreateListWorkerInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListWorkerInstancesWithChan invokes the oceanbasepro.ListWorkerInstances API asynchronously
func (client *Client) ListWorkerInstancesWithChan(request *ListWorkerInstancesRequest) (<-chan *ListWorkerInstancesResponse, <-chan error) {
	responseChan := make(chan *ListWorkerInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWorkerInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWorkerInstancesWithCallback invokes the oceanbasepro.ListWorkerInstances API asynchronously
func (client *Client) ListWorkerInstancesWithCallback(request *ListWorkerInstancesRequest, callback func(response *ListWorkerInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWorkerInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListWorkerInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWorkerInstancesRequest is the request struct for api ListWorkerInstances
type ListWorkerInstancesRequest struct {
	*requests.RpcRequest
	OnlyBindable requests.Boolean `position:"Body" name:"OnlyBindable"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	Specs        *[]string        `position:"Body" name:"Specs"  type:"Json"`
	InstanceName string           `position:"Body" name:"InstanceName"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	SourceType   string           `position:"Body" name:"SourceType"`
	DestType     string           `position:"Body" name:"DestType"`
}

// ListWorkerInstancesResponse is the response struct for api ListWorkerInstances
type ListWorkerInstancesResponse struct {
	*responses.BaseResponse
}

// CreateListWorkerInstancesRequest creates a request to invoke ListWorkerInstances API
func CreateListWorkerInstancesRequest() (request *ListWorkerInstancesRequest) {
	request = &ListWorkerInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ListWorkerInstances", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListWorkerInstancesResponse creates a response to parse from ListWorkerInstances response
func CreateListWorkerInstancesResponse() (response *ListWorkerInstancesResponse) {
	response = &ListWorkerInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
