package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOpsItems invokes the oos.ListOpsItems API synchronously
func (client *Client) ListOpsItems(request *ListOpsItemsRequest) (response *ListOpsItemsResponse, err error) {
	response = CreateListOpsItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ListOpsItemsWithChan invokes the oos.ListOpsItems API asynchronously
func (client *Client) ListOpsItemsWithChan(request *ListOpsItemsRequest) (<-chan *ListOpsItemsResponse, <-chan error) {
	responseChan := make(chan *ListOpsItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOpsItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOpsItemsWithCallback invokes the oos.ListOpsItems API asynchronously
func (client *Client) ListOpsItemsWithCallback(request *ListOpsItemsRequest, callback func(response *ListOpsItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOpsItemsResponse
		var err error
		defer close(result)
		response, err = client.ListOpsItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOpsItemsRequest is the request struct for api ListOpsItems
type ListOpsItemsRequest struct {
	*requests.RpcRequest
	ResourceTags string                `position:"Query" name:"ResourceTags"`
	Tags         string                `position:"Query" name:"Tags"`
	Filter       *[]ListOpsItemsFilter `position:"Query" name:"Filter"  type:"Repeated"`
	NextToken    string                `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer      `position:"Query" name:"MaxResults"`
}

// ListOpsItemsFilter is a repeated param struct in ListOpsItemsRequest
type ListOpsItemsFilter struct {
	Name     string    `name:"Name"`
	Value    *[]string `name:"Value" type:"Repeated"`
	Operator string    `name:"Operator"`
}

// ListOpsItemsResponse is the response struct for api ListOpsItems
type ListOpsItemsResponse struct {
	*responses.BaseResponse
	NextToken  string                  `json:"NextToken" xml:"NextToken"`
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	MaxResults int                     `json:"MaxResults" xml:"MaxResults"`
	TotalCount int                     `json:"TotalCount" xml:"TotalCount"`
	OpsItems   []OpsItemInListOpsItems `json:"OpsItems" xml:"OpsItems"`
}

// CreateListOpsItemsRequest creates a request to invoke ListOpsItems API
func CreateListOpsItemsRequest() (request *ListOpsItemsRequest) {
	request = &ListOpsItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListOpsItems", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOpsItemsResponse creates a response to parse from ListOpsItems response
func CreateListOpsItemsResponse() (response *ListOpsItemsResponse) {
	response = &ListOpsItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
