package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEndPoint invokes the openanalytics_open.GetEndPoint API synchronously
func (client *Client) GetEndPoint(request *GetEndPointRequest) (response *GetEndPointResponse, err error) {
	response = CreateGetEndPointResponse()
	err = client.DoAction(request, response)
	return
}

// GetEndPointWithChan invokes the openanalytics_open.GetEndPoint API asynchronously
func (client *Client) GetEndPointWithChan(request *GetEndPointRequest) (<-chan *GetEndPointResponse, <-chan error) {
	responseChan := make(chan *GetEndPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEndPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEndPointWithCallback invokes the openanalytics_open.GetEndPoint API asynchronously
func (client *Client) GetEndPointWithCallback(request *GetEndPointRequest, callback func(response *GetEndPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEndPointResponse
		var err error
		defer close(result)
		response, err = client.GetEndPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEndPointRequest is the request struct for api GetEndPoint
type GetEndPointRequest struct {
	*requests.RpcRequest
	EndPointID string `position:"Body" name:"EndPointID"`
}

// GetEndPointResponse is the response struct for api GetEndPoint
type GetEndPointResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	RegionId     string       `json:"RegionId" xml:"RegionId"`
	EndPointInfo EndPointInfo `json:"EndPointInfo" xml:"EndPointInfo"`
}

// CreateGetEndPointRequest creates a request to invoke GetEndPoint API
func CreateGetEndPointRequest() (request *GetEndPointRequest) {
	request = &GetEndPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "GetEndPoint", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEndPointResponse creates a response to parse from GetEndPoint response
func CreateGetEndPointResponse() (response *GetEndPointResponse) {
	response = &GetEndPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
