package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFunctionCurrentVersion invokes the opensearch.GetFunctionCurrentVersion API synchronously
func (client *Client) GetFunctionCurrentVersion(request *GetFunctionCurrentVersionRequest) (response *GetFunctionCurrentVersionResponse, err error) {
	response = CreateGetFunctionCurrentVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetFunctionCurrentVersionWithChan invokes the opensearch.GetFunctionCurrentVersion API asynchronously
func (client *Client) GetFunctionCurrentVersionWithChan(request *GetFunctionCurrentVersionRequest) (<-chan *GetFunctionCurrentVersionResponse, <-chan error) {
	responseChan := make(chan *GetFunctionCurrentVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFunctionCurrentVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFunctionCurrentVersionWithCallback invokes the opensearch.GetFunctionCurrentVersion API asynchronously
func (client *Client) GetFunctionCurrentVersionWithCallback(request *GetFunctionCurrentVersionRequest, callback func(response *GetFunctionCurrentVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFunctionCurrentVersionResponse
		var err error
		defer close(result)
		response, err = client.GetFunctionCurrentVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFunctionCurrentVersionRequest is the request struct for api GetFunctionCurrentVersion
type GetFunctionCurrentVersionRequest struct {
	*requests.RoaRequest
	ModelType    string `position:"Query" name:"modelType"`
	FunctionName string `position:"Path" name:"functionName"`
	Domain       string `position:"Query" name:"domain"`
	FunctionType string `position:"Query" name:"functionType"`
	Category     string `position:"Query" name:"category"`
}

// GetFunctionCurrentVersionResponse is the response struct for api GetFunctionCurrentVersion
type GetFunctionCurrentVersionResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetFunctionCurrentVersionRequest creates a request to invoke GetFunctionCurrentVersion API
func CreateGetFunctionCurrentVersionRequest() (request *GetFunctionCurrentVersionRequest) {
	request = &GetFunctionCurrentVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "GetFunctionCurrentVersion", "/v4/openapi/functions/[functionName]/current-version", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFunctionCurrentVersionResponse creates a response to parse from GetFunctionCurrentVersion response
func CreateGetFunctionCurrentVersionResponse() (response *GetFunctionCurrentVersionResponse) {
	response = &GetFunctionCurrentVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
