package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScheduledTasks invokes the opensearch.ListScheduledTasks API synchronously
func (client *Client) ListScheduledTasks(request *ListScheduledTasksRequest) (response *ListScheduledTasksResponse, err error) {
	response = CreateListScheduledTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListScheduledTasksWithChan invokes the opensearch.ListScheduledTasks API asynchronously
func (client *Client) ListScheduledTasksWithChan(request *ListScheduledTasksRequest) (<-chan *ListScheduledTasksResponse, <-chan error) {
	responseChan := make(chan *ListScheduledTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScheduledTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScheduledTasksWithCallback invokes the opensearch.ListScheduledTasks API asynchronously
func (client *Client) ListScheduledTasksWithCallback(request *ListScheduledTasksRequest, callback func(response *ListScheduledTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScheduledTasksResponse
		var err error
		defer close(result)
		response, err = client.ListScheduledTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScheduledTasksRequest is the request struct for api ListScheduledTasks
type ListScheduledTasksRequest struct {
	*requests.RoaRequest
	PageSize         requests.Integer `position:"Query" name:"pageSize"`
	Type             string           `position:"Query" name:"type"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
	PageNumber       requests.Integer `position:"Query" name:"pageNumber"`
}

// ListScheduledTasksResponse is the response struct for api ListScheduledTasks
type ListScheduledTasksResponse struct {
	*responses.BaseResponse
	TotalCount int64                    `json:"totalCount" xml:"totalCount"`
	RequestId  string                   `json:"requestId" xml:"requestId"`
	Result     []map[string]interface{} `json:"result" xml:"result"`
}

// CreateListScheduledTasksRequest creates a request to invoke ListScheduledTasks API
func CreateListScheduledTasksRequest() (request *ListScheduledTasksRequest) {
	request = &ListScheduledTasksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListScheduledTasks", "/v4/openapi/app-groups/[appGroupIdentity]/scheduled-tasks", "", "")
	request.Method = requests.GET
	return
}

// CreateListScheduledTasksResponse creates a response to parse from ListScheduledTasks response
func CreateListScheduledTasksResponse() (response *ListScheduledTasksResponse) {
	response = &ListScheduledTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
