package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveInterventionDictionary invokes the opensearch.RemoveInterventionDictionary API synchronously
func (client *Client) RemoveInterventionDictionary(request *RemoveInterventionDictionaryRequest) (response *RemoveInterventionDictionaryResponse, err error) {
	response = CreateRemoveInterventionDictionaryResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveInterventionDictionaryWithChan invokes the opensearch.RemoveInterventionDictionary API asynchronously
func (client *Client) RemoveInterventionDictionaryWithChan(request *RemoveInterventionDictionaryRequest) (<-chan *RemoveInterventionDictionaryResponse, <-chan error) {
	responseChan := make(chan *RemoveInterventionDictionaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveInterventionDictionary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveInterventionDictionaryWithCallback invokes the opensearch.RemoveInterventionDictionary API asynchronously
func (client *Client) RemoveInterventionDictionaryWithCallback(request *RemoveInterventionDictionaryRequest, callback func(response *RemoveInterventionDictionaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveInterventionDictionaryResponse
		var err error
		defer close(result)
		response, err = client.RemoveInterventionDictionary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveInterventionDictionaryRequest is the request struct for api RemoveInterventionDictionary
type RemoveInterventionDictionaryRequest struct {
	*requests.RoaRequest
	Name string `position:"Path" name:"name"`
}

// RemoveInterventionDictionaryResponse is the response struct for api RemoveInterventionDictionary
type RemoveInterventionDictionaryResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"requestId" xml:"requestId"`
	Result    ResultInRemoveInterventionDictionary `json:"result" xml:"result"`
}

// CreateRemoveInterventionDictionaryRequest creates a request to invoke RemoveInterventionDictionary API
func CreateRemoveInterventionDictionaryRequest() (request *RemoveInterventionDictionaryRequest) {
	request = &RemoveInterventionDictionaryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RemoveInterventionDictionary", "/v4/openapi/intervention-dictionaries/[name]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveInterventionDictionaryResponse creates a response to parse from RemoveInterventionDictionary response
func CreateRemoveInterventionDictionaryResponse() (response *RemoveInterventionDictionaryResponse) {
	response = &RemoveInterventionDictionaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
