package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateDataSources invokes the opensearch.ValidateDataSources API synchronously
func (client *Client) ValidateDataSources(request *ValidateDataSourcesRequest) (response *ValidateDataSourcesResponse, err error) {
	response = CreateValidateDataSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateDataSourcesWithChan invokes the opensearch.ValidateDataSources API asynchronously
func (client *Client) ValidateDataSourcesWithChan(request *ValidateDataSourcesRequest) (<-chan *ValidateDataSourcesResponse, <-chan error) {
	responseChan := make(chan *ValidateDataSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateDataSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateDataSourcesWithCallback invokes the opensearch.ValidateDataSources API asynchronously
func (client *Client) ValidateDataSourcesWithCallback(request *ValidateDataSourcesRequest, callback func(response *ValidateDataSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateDataSourcesResponse
		var err error
		defer close(result)
		response, err = client.ValidateDataSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateDataSourcesRequest is the request struct for api ValidateDataSources
type ValidateDataSourcesRequest struct {
	*requests.RoaRequest
}

// ValidateDataSourcesResponse is the response struct for api ValidateDataSources
type ValidateDataSourcesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateValidateDataSourcesRequest creates a request to invoke ValidateDataSources API
func CreateValidateDataSourcesRequest() (request *ValidateDataSourcesRequest) {
	request = &ValidateDataSourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ValidateDataSources", "/v4/openapi/assist/data-sources/validations", "", "")
	request.Method = requests.POST
	return
}

// CreateValidateDataSourcesResponse creates a response to parse from ValidateDataSources response
func CreateValidateDataSourcesResponse() (response *ValidateDataSourcesResponse) {
	response = &ValidateDataSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
