package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceBindNumber invokes the outboundbot.CreateInstanceBindNumber API synchronously
func (client *Client) CreateInstanceBindNumber(request *CreateInstanceBindNumberRequest) (response *CreateInstanceBindNumberResponse, err error) {
	response = CreateCreateInstanceBindNumberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceBindNumberWithChan invokes the outboundbot.CreateInstanceBindNumber API asynchronously
func (client *Client) CreateInstanceBindNumberWithChan(request *CreateInstanceBindNumberRequest) (<-chan *CreateInstanceBindNumberResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceBindNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceBindNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceBindNumberWithCallback invokes the outboundbot.CreateInstanceBindNumber API asynchronously
func (client *Client) CreateInstanceBindNumberWithCallback(request *CreateInstanceBindNumberRequest, callback func(response *CreateInstanceBindNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceBindNumberResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceBindNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceBindNumberRequest is the request struct for api CreateInstanceBindNumber
type CreateInstanceBindNumberRequest struct {
	*requests.RpcRequest
	InstanceList string `position:"Query" name:"InstanceList"`
	Number       string `position:"Query" name:"Number"`
}

// CreateInstanceBindNumberResponse is the response struct for api CreateInstanceBindNumber
type CreateInstanceBindNumberResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreateInstanceBindNumberRequest creates a request to invoke CreateInstanceBindNumber API
func CreateCreateInstanceBindNumberRequest() (request *CreateInstanceBindNumberRequest) {
	request = &CreateInstanceBindNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateInstanceBindNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateInstanceBindNumberResponse creates a response to parse from CreateInstanceBindNumber response
func CreateCreateInstanceBindNumberResponse() (response *CreateInstanceBindNumberResponse) {
	response = &CreateInstanceBindNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
