package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDatasource invokes the paifeaturestore.DeleteDatasource API synchronously
func (client *Client) DeleteDatasource(request *DeleteDatasourceRequest) (response *DeleteDatasourceResponse, err error) {
	response = CreateDeleteDatasourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDatasourceWithChan invokes the paifeaturestore.DeleteDatasource API asynchronously
func (client *Client) DeleteDatasourceWithChan(request *DeleteDatasourceRequest) (<-chan *DeleteDatasourceResponse, <-chan error) {
	responseChan := make(chan *DeleteDatasourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDatasource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDatasourceWithCallback invokes the paifeaturestore.DeleteDatasource API asynchronously
func (client *Client) DeleteDatasourceWithCallback(request *DeleteDatasourceRequest, callback func(response *DeleteDatasourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDatasourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteDatasource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDatasourceRequest is the request struct for api DeleteDatasource
type DeleteDatasourceRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	DatasourceId string `position:"Path" name:"DatasourceId"`
}

// DeleteDatasourceResponse is the response struct for api DeleteDatasource
type DeleteDatasourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDatasourceRequest creates a request to invoke DeleteDatasource API
func CreateDeleteDatasourceRequest() (request *DeleteDatasourceRequest) {
	request = &DeleteDatasourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "DeleteDatasource", "/api/v1/instances/[InstanceId]/datasources/[DatasourceId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteDatasourceResponse creates a response to parse from DeleteDatasource response
func CreateDeleteDatasourceResponse() (response *DeleteDatasourceResponse) {
	response = &DeleteDatasourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
