package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFeatureEntity invokes the paifeaturestore.DeleteFeatureEntity API synchronously
func (client *Client) DeleteFeatureEntity(request *DeleteFeatureEntityRequest) (response *DeleteFeatureEntityResponse, err error) {
	response = CreateDeleteFeatureEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFeatureEntityWithChan invokes the paifeaturestore.DeleteFeatureEntity API asynchronously
func (client *Client) DeleteFeatureEntityWithChan(request *DeleteFeatureEntityRequest) (<-chan *DeleteFeatureEntityResponse, <-chan error) {
	responseChan := make(chan *DeleteFeatureEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFeatureEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFeatureEntityWithCallback invokes the paifeaturestore.DeleteFeatureEntity API asynchronously
func (client *Client) DeleteFeatureEntityWithCallback(request *DeleteFeatureEntityRequest, callback func(response *DeleteFeatureEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFeatureEntityResponse
		var err error
		defer close(result)
		response, err = client.DeleteFeatureEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFeatureEntityRequest is the request struct for api DeleteFeatureEntity
type DeleteFeatureEntityRequest struct {
	*requests.RoaRequest
	FeatureEntityId string `position:"Path" name:"FeatureEntityId"`
	InstanceId      string `position:"Path" name:"InstanceId"`
}

// DeleteFeatureEntityResponse is the response struct for api DeleteFeatureEntity
type DeleteFeatureEntityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFeatureEntityRequest creates a request to invoke DeleteFeatureEntity API
func CreateDeleteFeatureEntityRequest() (request *DeleteFeatureEntityRequest) {
	request = &DeleteFeatureEntityRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "DeleteFeatureEntity", "/api/v1/instances/[InstanceId]/featureentities/[FeatureEntityId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFeatureEntityResponse creates a response to parse from DeleteFeatureEntity response
func CreateDeleteFeatureEntityResponse() (response *DeleteFeatureEntityResponse) {
	response = &DeleteFeatureEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
