package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTaskLogs invokes the paifeaturestore.ListTaskLogs API synchronously
func (client *Client) ListTaskLogs(request *ListTaskLogsRequest) (response *ListTaskLogsResponse, err error) {
	response = CreateListTaskLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskLogsWithChan invokes the paifeaturestore.ListTaskLogs API asynchronously
func (client *Client) ListTaskLogsWithChan(request *ListTaskLogsRequest) (<-chan *ListTaskLogsResponse, <-chan error) {
	responseChan := make(chan *ListTaskLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTaskLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskLogsWithCallback invokes the paifeaturestore.ListTaskLogs API asynchronously
func (client *Client) ListTaskLogsWithCallback(request *ListTaskLogsRequest, callback func(response *ListTaskLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskLogsResponse
		var err error
		defer close(result)
		response, err = client.ListTaskLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskLogsRequest is the request struct for api ListTaskLogs
type ListTaskLogsRequest struct {
	*requests.RoaRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Path" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TaskId     string           `position:"Path" name:"TaskId"`
}

// ListTaskLogsResponse is the response struct for api ListTaskLogs
type ListTaskLogsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	Logs       []string `json:"Logs" xml:"Logs"`
}

// CreateListTaskLogsRequest creates a request to invoke ListTaskLogs API
func CreateListTaskLogsRequest() (request *ListTaskLogsRequest) {
	request = &ListTaskLogsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListTaskLogs", "/api/v1/instances/[InstanceId]/tasks/[TaskId]/logs", "", "")
	request.Method = requests.GET
	return
}

// CreateListTaskLogsResponse creates a response to parse from ListTaskLogs response
func CreateListTaskLogsResponse() (response *ListTaskLogsResponse) {
	response = &ListTaskLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
