package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishFeatureViewTable invokes the paifeaturestore.PublishFeatureViewTable API synchronously
func (client *Client) PublishFeatureViewTable(request *PublishFeatureViewTableRequest) (response *PublishFeatureViewTableResponse, err error) {
	response = CreatePublishFeatureViewTableResponse()
	err = client.DoAction(request, response)
	return
}

// PublishFeatureViewTableWithChan invokes the paifeaturestore.PublishFeatureViewTable API asynchronously
func (client *Client) PublishFeatureViewTableWithChan(request *PublishFeatureViewTableRequest) (<-chan *PublishFeatureViewTableResponse, <-chan error) {
	responseChan := make(chan *PublishFeatureViewTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishFeatureViewTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishFeatureViewTableWithCallback invokes the paifeaturestore.PublishFeatureViewTable API asynchronously
func (client *Client) PublishFeatureViewTableWithCallback(request *PublishFeatureViewTableRequest, callback func(response *PublishFeatureViewTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishFeatureViewTableResponse
		var err error
		defer close(result)
		response, err = client.PublishFeatureViewTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishFeatureViewTableRequest is the request struct for api PublishFeatureViewTable
type PublishFeatureViewTableRequest struct {
	*requests.RoaRequest
	Body          string `position:"Body" name:"body"`
	InstanceId    string `position:"Path" name:"InstanceId"`
	FeatureViewId string `position:"Path" name:"FeatureViewId"`
}

// PublishFeatureViewTableResponse is the response struct for api PublishFeatureViewTable
type PublishFeatureViewTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreatePublishFeatureViewTableRequest creates a request to invoke PublishFeatureViewTable API
func CreatePublishFeatureViewTableRequest() (request *PublishFeatureViewTableRequest) {
	request = &PublishFeatureViewTableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "PublishFeatureViewTable", "/api/v1/instances/[InstanceId]/featureviews/[FeatureViewId]/action/publishtable", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishFeatureViewTableResponse creates a response to parse from PublishFeatureViewTable response
func CreatePublishFeatureViewTableResponse() (response *PublishFeatureViewTableResponse) {
	response = &PublishFeatureViewTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
