package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DebugResourceRule invokes the pairecservice.DebugResourceRule API synchronously
func (client *Client) DebugResourceRule(request *DebugResourceRuleRequest) (response *DebugResourceRuleResponse, err error) {
	response = CreateDebugResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DebugResourceRuleWithChan invokes the pairecservice.DebugResourceRule API asynchronously
func (client *Client) DebugResourceRuleWithChan(request *DebugResourceRuleRequest) (<-chan *DebugResourceRuleResponse, <-chan error) {
	responseChan := make(chan *DebugResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DebugResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DebugResourceRuleWithCallback invokes the pairecservice.DebugResourceRule API asynchronously
func (client *Client) DebugResourceRuleWithCallback(request *DebugResourceRuleRequest, callback func(response *DebugResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DebugResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.DebugResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DebugResourceRuleRequest is the request struct for api DebugResourceRule
type DebugResourceRuleRequest struct {
	*requests.RoaRequest
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	MetricInfo     string `position:"Query" name:"MetricInfo"`
}

// DebugResourceRuleResponse is the response struct for api DebugResourceRule
type DebugResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId     string                 `json:"RequestId" xml:"RequestId"`
	CurrentValues map[string]interface{} `json:"CurrentValues" xml:"CurrentValues"`
	OutputValues  map[string]interface{} `json:"OutputValues" xml:"OutputValues"`
}

// CreateDebugResourceRuleRequest creates a request to invoke DebugResourceRule API
func CreateDebugResourceRuleRequest() (request *DebugResourceRuleRequest) {
	request = &DebugResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DebugResourceRule", "/api/v1/resourcerules/[ResourceRuleId]/action/debug", "", "")
	request.Method = requests.POST
	return
}

// CreateDebugResourceRuleResponse creates a response to parse from DebugResourceRule response
func CreateDebugResourceRuleResponse() (response *DebugResourceRuleResponse) {
	response = &DebugResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
