package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSampleConsistencyJob invokes the pairecservice.GetSampleConsistencyJob API synchronously
func (client *Client) GetSampleConsistencyJob(request *GetSampleConsistencyJobRequest) (response *GetSampleConsistencyJobResponse, err error) {
	response = CreateGetSampleConsistencyJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetSampleConsistencyJobWithChan invokes the pairecservice.GetSampleConsistencyJob API asynchronously
func (client *Client) GetSampleConsistencyJobWithChan(request *GetSampleConsistencyJobRequest) (<-chan *GetSampleConsistencyJobResponse, <-chan error) {
	responseChan := make(chan *GetSampleConsistencyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSampleConsistencyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSampleConsistencyJobWithCallback invokes the pairecservice.GetSampleConsistencyJob API asynchronously
func (client *Client) GetSampleConsistencyJobWithCallback(request *GetSampleConsistencyJobRequest, callback func(response *GetSampleConsistencyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSampleConsistencyJobResponse
		var err error
		defer close(result)
		response, err = client.GetSampleConsistencyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSampleConsistencyJobRequest is the request struct for api GetSampleConsistencyJob
type GetSampleConsistencyJobRequest struct {
	*requests.RoaRequest
	SampleConsistencyJobId string `position:"Path" name:"SampleConsistencyJobId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// GetSampleConsistencyJobResponse is the response struct for api GetSampleConsistencyJob
type GetSampleConsistencyJobResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	SampleConsistencyJobId string `json:"SampleConsistencyJobId" xml:"SampleConsistencyJobId"`
	Name                   string `json:"Name" xml:"Name"`
	SceneId                string `json:"SceneId" xml:"SceneId"`
	SceneName              string `json:"SceneName" xml:"SceneName"`
	EasModelServiceName    string `json:"EasModelServiceName" xml:"EasModelServiceName"`
	SampleRate             string `json:"SampleRate" xml:"SampleRate"`
	Duration               string `json:"Duration" xml:"Duration"`
	FeatureSaveResourceId  string `json:"FeatureSaveResourceId" xml:"FeatureSaveResourceId"`
	SampleTableName        string `json:"SampleTableName" xml:"SampleTableName"`
	UserIdField            string `json:"UserIdField" xml:"UserIdField"`
	ItemIdField            string `json:"ItemIdField" xml:"ItemIdField"`
	RequestIdField         string `json:"RequestIdField" xml:"RequestIdField"`
	PartitionField         string `json:"PartitionField" xml:"PartitionField"`
	PartitionFieldFormat   string `json:"PartitionFieldFormat" xml:"PartitionFieldFormat"`
	Logs                   string `json:"Logs" xml:"Logs"`
	Config                 string `json:"Config" xml:"Config"`
	Status                 string `json:"Status" xml:"Status"`
	StartTime              string `json:"StartTime" xml:"StartTime"`
	EndTime                string `json:"EndTime" xml:"EndTime"`
	GmtCreateTime          string `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime        string `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
}

// CreateGetSampleConsistencyJobRequest creates a request to invoke GetSampleConsistencyJob API
func CreateGetSampleConsistencyJobRequest() (request *GetSampleConsistencyJobRequest) {
	request = &GetSampleConsistencyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetSampleConsistencyJob", "/api/v1/sampleconsistencyjobs/[SampleConsistencyJobId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetSampleConsistencyJobResponse creates a response to parse from GetSampleConsistencyJob response
func CreateGetSampleConsistencyJobResponse() (response *GetSampleConsistencyJobResponse) {
	response = &GetSampleConsistencyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
