package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCrowdUsers invokes the pairecservice.ListCrowdUsers API synchronously
func (client *Client) ListCrowdUsers(request *ListCrowdUsersRequest) (response *ListCrowdUsersResponse, err error) {
	response = CreateListCrowdUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListCrowdUsersWithChan invokes the pairecservice.ListCrowdUsers API asynchronously
func (client *Client) ListCrowdUsersWithChan(request *ListCrowdUsersRequest) (<-chan *ListCrowdUsersResponse, <-chan error) {
	responseChan := make(chan *ListCrowdUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCrowdUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCrowdUsersWithCallback invokes the pairecservice.ListCrowdUsers API asynchronously
func (client *Client) ListCrowdUsersWithCallback(request *ListCrowdUsersRequest, callback func(response *ListCrowdUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCrowdUsersResponse
		var err error
		defer close(result)
		response, err = client.ListCrowdUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCrowdUsersRequest is the request struct for api ListCrowdUsers
type ListCrowdUsersRequest struct {
	*requests.RoaRequest
	CrowdId    string `position:"Path" name:"CrowdId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListCrowdUsersResponse is the response struct for api ListCrowdUsers
type ListCrowdUsersResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Users      []string `json:"Users" xml:"Users"`
}

// CreateListCrowdUsersRequest creates a request to invoke ListCrowdUsers API
func CreateListCrowdUsersRequest() (request *ListCrowdUsersRequest) {
	request = &ListCrowdUsersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListCrowdUsers", "/api/v1/crowds/[CrowdId]/users", "", "")
	request.Method = requests.GET
	return
}

// CreateListCrowdUsersResponse creates a response to parse from ListCrowdUsers response
func CreateListCrowdUsersResponse() (response *ListCrowdUsersResponse) {
	response = &ListCrowdUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
