package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExperimentGroups invokes the pairecservice.ListExperimentGroups API synchronously
func (client *Client) ListExperimentGroups(request *ListExperimentGroupsRequest) (response *ListExperimentGroupsResponse, err error) {
	response = CreateListExperimentGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExperimentGroupsWithChan invokes the pairecservice.ListExperimentGroups API asynchronously
func (client *Client) ListExperimentGroupsWithChan(request *ListExperimentGroupsRequest) (<-chan *ListExperimentGroupsResponse, <-chan error) {
	responseChan := make(chan *ListExperimentGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExperimentGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExperimentGroupsWithCallback invokes the pairecservice.ListExperimentGroups API asynchronously
func (client *Client) ListExperimentGroupsWithCallback(request *ListExperimentGroupsRequest, callback func(response *ListExperimentGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExperimentGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListExperimentGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExperimentGroupsRequest is the request struct for api ListExperimentGroups
type ListExperimentGroupsRequest struct {
	*requests.RoaRequest
	TimeRangeEnd   string `position:"Query" name:"TimeRangeEnd"`
	LayerId        string `position:"Query" name:"LayerId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	TimeRangeStart string `position:"Query" name:"TimeRangeStart"`
	Status         string `position:"Query" name:"Status"`
}

// ListExperimentGroupsResponse is the response struct for api ListExperimentGroups
type ListExperimentGroupsResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int64                  `json:"TotalCount" xml:"TotalCount"`
	ExperimentGroups []ExperimentGroupsItem `json:"ExperimentGroups" xml:"ExperimentGroups"`
}

// CreateListExperimentGroupsRequest creates a request to invoke ListExperimentGroups API
func CreateListExperimentGroupsRequest() (request *ListExperimentGroupsRequest) {
	request = &ListExperimentGroupsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListExperimentGroups", "/api/v1/experimentgroups", "", "")
	request.Method = requests.GET
	return
}

// CreateListExperimentGroupsResponse creates a response to parse from ListExperimentGroups response
func CreateListExperimentGroupsResponse() (response *ListExperimentGroupsResponse) {
	response = &ListExperimentGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
