package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncFeatureConsistencyCheckJobReplayLog invokes the pairecservice.SyncFeatureConsistencyCheckJobReplayLog API synchronously
func (client *Client) SyncFeatureConsistencyCheckJobReplayLog(request *SyncFeatureConsistencyCheckJobReplayLogRequest) (response *SyncFeatureConsistencyCheckJobReplayLogResponse, err error) {
	response = CreateSyncFeatureConsistencyCheckJobReplayLogResponse()
	err = client.DoAction(request, response)
	return
}

// SyncFeatureConsistencyCheckJobReplayLogWithChan invokes the pairecservice.SyncFeatureConsistencyCheckJobReplayLog API asynchronously
func (client *Client) SyncFeatureConsistencyCheckJobReplayLogWithChan(request *SyncFeatureConsistencyCheckJobReplayLogRequest) (<-chan *SyncFeatureConsistencyCheckJobReplayLogResponse, <-chan error) {
	responseChan := make(chan *SyncFeatureConsistencyCheckJobReplayLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncFeatureConsistencyCheckJobReplayLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncFeatureConsistencyCheckJobReplayLogWithCallback invokes the pairecservice.SyncFeatureConsistencyCheckJobReplayLog API asynchronously
func (client *Client) SyncFeatureConsistencyCheckJobReplayLogWithCallback(request *SyncFeatureConsistencyCheckJobReplayLogRequest, callback func(response *SyncFeatureConsistencyCheckJobReplayLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncFeatureConsistencyCheckJobReplayLogResponse
		var err error
		defer close(result)
		response, err = client.SyncFeatureConsistencyCheckJobReplayLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncFeatureConsistencyCheckJobReplayLogRequest is the request struct for api SyncFeatureConsistencyCheckJobReplayLog
type SyncFeatureConsistencyCheckJobReplayLogRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// SyncFeatureConsistencyCheckJobReplayLogResponse is the response struct for api SyncFeatureConsistencyCheckJobReplayLog
type SyncFeatureConsistencyCheckJobReplayLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSyncFeatureConsistencyCheckJobReplayLogRequest creates a request to invoke SyncFeatureConsistencyCheckJobReplayLog API
func CreateSyncFeatureConsistencyCheckJobReplayLogRequest() (request *SyncFeatureConsistencyCheckJobReplayLogRequest) {
	request = &SyncFeatureConsistencyCheckJobReplayLogRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "SyncFeatureConsistencyCheckJobReplayLog", "/api/v1/featureconsistencycheck/jobs/action/syncreplaylog", "", "")
	request.Method = requests.POST
	return
}

// CreateSyncFeatureConsistencyCheckJobReplayLogResponse creates a response to parse from SyncFeatureConsistencyCheckJobReplayLog response
func CreateSyncFeatureConsistencyCheckJobReplayLogResponse() (response *SyncFeatureConsistencyCheckJobReplayLogResponse) {
	response = &SyncFeatureConsistencyCheckJobReplayLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
