package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateABMetricGroup invokes the pairecservice.UpdateABMetricGroup API synchronously
func (client *Client) UpdateABMetricGroup(request *UpdateABMetricGroupRequest) (response *UpdateABMetricGroupResponse, err error) {
	response = CreateUpdateABMetricGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateABMetricGroupWithChan invokes the pairecservice.UpdateABMetricGroup API asynchronously
func (client *Client) UpdateABMetricGroupWithChan(request *UpdateABMetricGroupRequest) (<-chan *UpdateABMetricGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateABMetricGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateABMetricGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateABMetricGroupWithCallback invokes the pairecservice.UpdateABMetricGroup API asynchronously
func (client *Client) UpdateABMetricGroupWithCallback(request *UpdateABMetricGroupRequest, callback func(response *UpdateABMetricGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateABMetricGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateABMetricGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateABMetricGroupRequest is the request struct for api UpdateABMetricGroup
type UpdateABMetricGroupRequest struct {
	*requests.RoaRequest
	ABMetricGroupId string `position:"Path" name:"ABMetricGroupId"`
	Body            string `position:"Body" name:"body"`
}

// UpdateABMetricGroupResponse is the response struct for api UpdateABMetricGroup
type UpdateABMetricGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateABMetricGroupRequest creates a request to invoke UpdateABMetricGroup API
func CreateUpdateABMetricGroupRequest() (request *UpdateABMetricGroupRequest) {
	request = &UpdateABMetricGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateABMetricGroup", "/api/v1/abmetricgroups/[ABMetricGroupId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateABMetricGroupResponse creates a response to parse from UpdateABMetricGroup response
func CreateUpdateABMetricGroupResponse() (response *UpdateABMetricGroupResponse) {
	response = &UpdateABMetricGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
