package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficControlTaskTraffic invokes the pairecservice.UpdateTrafficControlTaskTraffic API synchronously
func (client *Client) UpdateTrafficControlTaskTraffic(request *UpdateTrafficControlTaskTrafficRequest) (response *UpdateTrafficControlTaskTrafficResponse, err error) {
	response = CreateUpdateTrafficControlTaskTrafficResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficControlTaskTrafficWithChan invokes the pairecservice.UpdateTrafficControlTaskTraffic API asynchronously
func (client *Client) UpdateTrafficControlTaskTrafficWithChan(request *UpdateTrafficControlTaskTrafficRequest) (<-chan *UpdateTrafficControlTaskTrafficResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficControlTaskTrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficControlTaskTraffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficControlTaskTrafficWithCallback invokes the pairecservice.UpdateTrafficControlTaskTraffic API asynchronously
func (client *Client) UpdateTrafficControlTaskTrafficWithCallback(request *UpdateTrafficControlTaskTrafficRequest, callback func(response *UpdateTrafficControlTaskTrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficControlTaskTrafficResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficControlTaskTraffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficControlTaskTrafficRequest is the request struct for api UpdateTrafficControlTaskTraffic
type UpdateTrafficControlTaskTrafficRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
	NewParam3            string `position:"Query" name:"new-param-3"`
}

// UpdateTrafficControlTaskTrafficResponse is the response struct for api UpdateTrafficControlTaskTraffic
type UpdateTrafficControlTaskTrafficResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficControlTaskTrafficRequest creates a request to invoke UpdateTrafficControlTaskTraffic API
func CreateUpdateTrafficControlTaskTrafficRequest() (request *UpdateTrafficControlTaskTrafficRequest) {
	request = &UpdateTrafficControlTaskTrafficRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateTrafficControlTaskTraffic", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/action/traffic", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTrafficControlTaskTrafficResponse creates a response to parse from UpdateTrafficControlTaskTraffic response
func CreateUpdateTrafficControlTaskTrafficResponse() (response *UpdateTrafficControlTaskTrafficResponse) {
	response = &UpdateTrafficControlTaskTrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
