package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountList invokes the polardbx.DescribeAccountList API synchronously
func (client *Client) DescribeAccountList(request *DescribeAccountListRequest) (response *DescribeAccountListResponse, err error) {
	response = CreateDescribeAccountListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountListWithChan invokes the polardbx.DescribeAccountList API asynchronously
func (client *Client) DescribeAccountListWithChan(request *DescribeAccountListRequest) (<-chan *DescribeAccountListResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountListWithCallback invokes the polardbx.DescribeAccountList API asynchronously
func (client *Client) DescribeAccountListWithCallback(request *DescribeAccountListRequest, callback func(response *DescribeAccountListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountListRequest is the request struct for api DescribeAccountList
type DescribeAccountListRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	AccountType    string `position:"Query" name:"AccountType"`
	AccountName    string `position:"Query" name:"AccountName"`
}

// DescribeAccountListResponse is the response struct for api DescribeAccountList
type DescribeAccountListResponse struct {
	*responses.BaseResponse
	Message   string    `json:"Message" xml:"Message"`
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Data      []Account `json:"Data" xml:"Data"`
}

// CreateDescribeAccountListRequest creates a request to invoke DescribeAccountList API
func CreateDescribeAccountListRequest() (request *DescribeAccountListRequest) {
	request = &DescribeAccountListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeAccountList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountListResponse creates a response to parse from DescribeAccountList response
func CreateDescribeAccountListResponse() (response *DescribeAccountListResponse) {
	response = &DescribeAccountListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
